<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailEtatSaisieEnLigne Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DetailEtatSaisieEnLigne
 * @subpackage Structs
 */
class DetailEtatSaisieEnLigne extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeSaisieEnLigne
     * @var int
     */
    public $CodeSaisieEnLigne;
    /**
     * The CodePret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CodePret;
    /**
     * The EstDelegataireCourtier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstDelegataireCourtier;
    /**
     * The TypeProcessus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypeProcessus;
    /**
     * Constructor method for DetailEtatSaisieEnLigne
     * @uses DetailEtatSaisieEnLigne::setCodeSaisieEnLigne()
     * @uses DetailEtatSaisieEnLigne::setCodePret()
     * @uses DetailEtatSaisieEnLigne::setEstDelegataireCourtier()
     * @uses DetailEtatSaisieEnLigne::setTypeProcessus()
     * @param int $codeSaisieEnLigne
     * @param int $codePret
     * @param bool $estDelegataireCourtier
     * @param string $typeProcessus
     */
    public function __construct($codeSaisieEnLigne = null, $codePret = null, $estDelegataireCourtier = null, $typeProcessus = null)
    {
        $this
            ->setCodeSaisieEnLigne($codeSaisieEnLigne)
            ->setCodePret($codePret)
            ->setEstDelegataireCourtier($estDelegataireCourtier)
            ->setTypeProcessus($typeProcessus);
    }
    /**
     * Get CodeSaisieEnLigne value
     * @return int|null
     */
    public function getCodeSaisieEnLigne()
    {
        return $this->CodeSaisieEnLigne;
    }
    /**
     * Set CodeSaisieEnLigne value
     * @param int $codeSaisieEnLigne
     * @return \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne
     */
    public function setCodeSaisieEnLigne($codeSaisieEnLigne = null)
    {
        // validation for constraint: int
        if (!is_null($codeSaisieEnLigne) && !(is_int($codeSaisieEnLigne) || ctype_digit($codeSaisieEnLigne))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeSaisieEnLigne, true), gettype($codeSaisieEnLigne)), __LINE__);
        }
        $this->CodeSaisieEnLigne = $codeSaisieEnLigne;
        return $this;
    }
    /**
     * Get CodePret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodePret()
    {
        return isset($this->CodePret) ? $this->CodePret : null;
    }
    /**
     * Set CodePret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codePret
     * @return \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne
     */
    public function setCodePret($codePret = null)
    {
        // validation for constraint: int
        if (!is_null($codePret) && !(is_int($codePret) || ctype_digit($codePret))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codePret, true), gettype($codePret)), __LINE__);
        }
        if (is_null($codePret) || (is_array($codePret) && empty($codePret))) {
            unset($this->CodePret);
        } else {
            $this->CodePret = $codePret;
        }
        return $this;
    }
    /**
     * Get EstDelegataireCourtier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstDelegataireCourtier()
    {
        return isset($this->EstDelegataireCourtier) ? $this->EstDelegataireCourtier : null;
    }
    /**
     * Set EstDelegataireCourtier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estDelegataireCourtier
     * @return \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne
     */
    public function setEstDelegataireCourtier($estDelegataireCourtier = null)
    {
        // validation for constraint: boolean
        if (!is_null($estDelegataireCourtier) && !is_bool($estDelegataireCourtier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estDelegataireCourtier, true), gettype($estDelegataireCourtier)), __LINE__);
        }
        if (is_null($estDelegataireCourtier) || (is_array($estDelegataireCourtier) && empty($estDelegataireCourtier))) {
            unset($this->EstDelegataireCourtier);
        } else {
            $this->EstDelegataireCourtier = $estDelegataireCourtier;
        }
        return $this;
    }
    /**
     * Get TypeProcessus value
     * @return string|null
     */
    public function getTypeProcessus()
    {
        return $this->TypeProcessus;
    }
    /**
     * Set TypeProcessus value
     * @uses \CfcalSasieSDK\Enum\TypeProcessus::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeProcessus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeProcessus
     * @return \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne
     */
    public function setTypeProcessus($typeProcessus = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeProcessus::valueIsValid($typeProcessus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeProcessus', is_array($typeProcessus) ? implode(', ', $typeProcessus) : var_export($typeProcessus, true), implode(', ', \CfcalSasieSDK\Enum\TypeProcessus::getValidValues())), __LINE__);
        }
        $this->TypeProcessus = $typeProcessus;
        return $this;
    }
}
