<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescriptionBien Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DescriptionBien
 * @subpackage Structs
 */
class DescriptionBien extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Libelle
     * @var string
     */
    public $Libelle;
    /**
     * The Nombre
     * @var int
     */
    public $Nombre;
    /**
     * Constructor method for DescriptionBien
     * @uses DescriptionBien::setLibelle()
     * @uses DescriptionBien::setNombre()
     * @param string $libelle
     * @param int $nombre
     */
    public function __construct($libelle = null, $nombre = null)
    {
        $this
            ->setLibelle($libelle)
            ->setNombre($nombre);
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @uses \CfcalSasieSDK\Enum\TypeDescriptionBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeDescriptionBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $libelle
     * @return \CfcalSasieSDK\Entity\DescriptionBien
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeDescriptionBien::valueIsValid($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeDescriptionBien', is_array($libelle) ? implode(', ', $libelle) : var_export($libelle, true), implode(', ', \CfcalSasieSDK\Enum\TypeDescriptionBien::getValidValues())), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Get Nombre value
     * @return int|null
     */
    public function getNombre()
    {
        return $this->Nombre;
    }
    /**
     * Set Nombre value
     * @param int $nombre
     * @return \CfcalSasieSDK\Entity\DescriptionBien
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: int
        if (!is_null($nombre) && !(is_int($nombre) || ctype_digit($nombre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->Nombre = $nombre;
        return $this;
    }
}
