<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoproprieteBien Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CoproprieteBien
 * @subpackage Structs
 */
class CoproprieteBien extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Lot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lot;
    /**
     * The Libelle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Libelle;
    /**
     * The Tantieme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tantieme;
    /**
     * Constructor method for CoproprieteBien
     * @uses CoproprieteBien::setLot()
     * @uses CoproprieteBien::setLibelle()
     * @uses CoproprieteBien::setTantieme()
     * @param string $lot
     * @param string $libelle
     * @param string $tantieme
     */
    public function __construct($lot = null, $libelle = null, $tantieme = null)
    {
        $this
            ->setLot($lot)
            ->setLibelle($libelle)
            ->setTantieme($tantieme);
    }
    /**
     * Get Lot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLot()
    {
        return isset($this->Lot) ? $this->Lot : null;
    }
    /**
     * Set Lot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lot
     * @return \CfcalSasieSDK\Entity\CoproprieteBien
     */
    public function setLot($lot = null)
    {
        // validation for constraint: string
        if (!is_null($lot) && !is_string($lot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lot, true), gettype($lot)), __LINE__);
        }
        if (is_null($lot) || (is_array($lot) && empty($lot))) {
            unset($this->Lot);
        } else {
            $this->Lot = $lot;
        }
        return $this;
    }
    /**
     * Get Libelle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLibelle()
    {
        return isset($this->Libelle) ? $this->Libelle : null;
    }
    /**
     * Set Libelle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $libelle
     * @return \CfcalSasieSDK\Entity\CoproprieteBien
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libelle, true), gettype($libelle)), __LINE__);
        }
        if (is_null($libelle) || (is_array($libelle) && empty($libelle))) {
            unset($this->Libelle);
        } else {
            $this->Libelle = $libelle;
        }
        return $this;
    }
    /**
     * Get Tantieme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTantieme()
    {
        return isset($this->Tantieme) ? $this->Tantieme : null;
    }
    /**
     * Set Tantieme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tantieme
     * @return \CfcalSasieSDK\Entity\CoproprieteBien
     */
    public function setTantieme($tantieme = null)
    {
        // validation for constraint: string
        if (!is_null($tantieme) && !is_string($tantieme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tantieme, true), gettype($tantieme)), __LINE__);
        }
        if (is_null($tantieme) || (is_array($tantieme) && empty($tantieme))) {
            unset($this->Tantieme);
        } else {
            $this->Tantieme = $tantieme;
        }
        return $this;
    }
}
