<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contacts Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Contacts
 * @subpackage Structs
 */
class Contacts extends AbstractStructBase
{
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Contact[]
     */
    public $Contact;
    /**
     * Constructor method for Contacts
     * @uses Contacts::setContact()
     * @param \CfcalSasieSDK\Entity\Contact[] $contact
     */
    public function __construct(array $contact = array())
    {
        $this
            ->setContact($contact);
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Contact[]|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactForArrayConstraintsFromSetContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactsContactItem) {
            // validation for constraint: itemType
            if (!$contactsContactItem instanceof \CfcalSasieSDK\Entity\Contact) {
                $invalidValues[] = is_object($contactsContactItem) ? get_class($contactsContactItem) : sprintf('%s(%s)', gettype($contactsContactItem), var_export($contactsContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contact property can only contain items of type \CfcalSasieSDK\Entity\Contact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Contact[] $contact
     * @return \CfcalSasieSDK\Entity\Contacts
     */
    public function setContact(array $contact = array())
    {
        // validation for constraint: array
        if ('' !== ($contactArrayErrorMessage = self::validateContactForArrayConstraintsFromSetContact($contact))) {
            throw new \InvalidArgumentException($contactArrayErrorMessage, __LINE__);
        }
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Add item to Contact value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Contact $item
     * @return \CfcalSasieSDK\Entity\Contacts
     */
    public function addToContact(\CfcalSasieSDK\Entity\Contact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Contact) {
            throw new \InvalidArgumentException(sprintf('The Contact property can only contain items of type \CfcalSasieSDK\Entity\Contact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contact[] = $item;
        return $this;
    }
}
