<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Contact
 * @subpackage Structs
 */
class Contact extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The TypeCoordonnee
     * @var string
     */
    public $TypeCoordonnee;
    /**
     * The Coordonnee
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Coordonnee;
    /**
     * The CodePays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePays;
    /**
     * Constructor method for Contact
     * @uses Contact::setTypeCoordonnee()
     * @uses Contact::setCoordonnee()
     * @uses Contact::setCodePays()
     * @param string $typeCoordonnee
     * @param string $coordonnee
     * @param string $codePays
     */
    public function __construct($typeCoordonnee = null, $coordonnee = null, $codePays = null)
    {
        $this
            ->setTypeCoordonnee($typeCoordonnee)
            ->setCoordonnee($coordonnee)
            ->setCodePays($codePays);
    }
    /**
     * Get TypeCoordonnee value
     * @return string|null
     */
    public function getTypeCoordonnee()
    {
        return $this->TypeCoordonnee;
    }
    /**
     * Set TypeCoordonnee value
     * @uses \CfcalSasieSDK\Enum\TypeCoordonnee::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeCoordonnee::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeCoordonnee
     * @return \CfcalSasieSDK\Entity\Contact
     */
    public function setTypeCoordonnee($typeCoordonnee = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeCoordonnee::valueIsValid($typeCoordonnee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeCoordonnee', is_array($typeCoordonnee) ? implode(', ', $typeCoordonnee) : var_export($typeCoordonnee, true), implode(', ', \CfcalSasieSDK\Enum\TypeCoordonnee::getValidValues())), __LINE__);
        }
        $this->TypeCoordonnee = $typeCoordonnee;
        return $this;
    }
    /**
     * Get Coordonnee value
     * @return string|null
     */
    public function getCoordonnee()
    {
        return $this->Coordonnee;
    }
    /**
     * Set Coordonnee value
     * @param string $coordonnee
     * @return \CfcalSasieSDK\Entity\Contact
     */
    public function setCoordonnee($coordonnee = null)
    {
        // validation for constraint: string
        if (!is_null($coordonnee) && !is_string($coordonnee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coordonnee, true), gettype($coordonnee)), __LINE__);
        }
        $this->Coordonnee = $coordonnee;
        return $this;
    }
    /**
     * Get CodePays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePays()
    {
        return isset($this->CodePays) ? $this->CodePays : null;
    }
    /**
     * Set CodePays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePays
     * @return \CfcalSasieSDK\Entity\Contact
     */
    public function setCodePays($codePays = null)
    {
        // validation for constraint: string
        if (!is_null($codePays) && !is_string($codePays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePays, true), gettype($codePays)), __LINE__);
        }
        if (is_null($codePays) || (is_array($codePays) && empty($codePays))) {
            unset($this->CodePays);
        } else {
            $this->CodePays = $codePays;
        }
        return $this;
    }
}
