<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charges Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Charges
 * @subpackage Structs
 */
class Charges extends AbstractStructBase
{
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Charge[]
     */
    public $Charge;
    /**
     * Constructor method for Charges
     * @uses Charges::setCharge()
     * @param \CfcalSasieSDK\Entity\Charge[] $charge
     */
    public function __construct(array $charge = array())
    {
        $this
            ->setCharge($charge);
    }
    /**
     * Get Charge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Charge[]|null
     */
    public function getCharge()
    {
        return isset($this->Charge) ? $this->Charge : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeForArrayConstraintsFromSetCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $chargesChargeItem) {
            // validation for constraint: itemType
            if (!$chargesChargeItem instanceof \CfcalSasieSDK\Entity\Charge) {
                $invalidValues[] = is_object($chargesChargeItem) ? get_class($chargesChargeItem) : sprintf('%s(%s)', gettype($chargesChargeItem), var_export($chargesChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charge property can only contain items of type \CfcalSasieSDK\Entity\Charge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Charge[] $charge
     * @return \CfcalSasieSDK\Entity\Charges
     */
    public function setCharge(array $charge = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeArrayErrorMessage = self::validateChargeForArrayConstraintsFromSetCharge($charge))) {
            throw new \InvalidArgumentException($chargeArrayErrorMessage, __LINE__);
        }
        if (is_null($charge) || (is_array($charge) && empty($charge))) {
            unset($this->Charge);
        } else {
            $this->Charge = $charge;
        }
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Charge $item
     * @return \CfcalSasieSDK\Entity\Charges
     */
    public function addToCharge(\CfcalSasieSDK\Entity\Charge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Charge) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of type \CfcalSasieSDK\Entity\Charge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
}
