<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Charge
 * @subpackage Structs
 */
class Charge extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Periodicite
     * @var string
     */
    public $Periodicite;
    /**
     * The Montant
     * @var float
     */
    public $Montant;
    /**
     * The EstPermanente
     * @var bool
     */
    public $EstPermanente;
    /**
     * The TypeCharge
     * @var string
     */
    public $TypeCharge;
    /**
     * Constructor method for Charge
     * @uses Charge::setPeriodicite()
     * @uses Charge::setMontant()
     * @uses Charge::setEstPermanente()
     * @uses Charge::setTypeCharge()
     * @param string $periodicite
     * @param float $montant
     * @param bool $estPermanente
     * @param string $typeCharge
     */
    public function __construct($periodicite = null, $montant = null, $estPermanente = null, $typeCharge = null)
    {
        $this
            ->setPeriodicite($periodicite)
            ->setMontant($montant)
            ->setEstPermanente($estPermanente)
            ->setTypeCharge($typeCharge);
    }
    /**
     * Get Periodicite value
     * @return string|null
     */
    public function getPeriodicite()
    {
        return $this->Periodicite;
    }
    /**
     * Set Periodicite value
     * @uses \CfcalSasieSDK\Enum\Periodicite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Periodicite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicite
     * @return \CfcalSasieSDK\Entity\Charge
     */
    public function setPeriodicite($periodicite = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Periodicite::valueIsValid($periodicite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Periodicite', is_array($periodicite) ? implode(', ', $periodicite) : var_export($periodicite, true), implode(', ', \CfcalSasieSDK\Enum\Periodicite::getValidValues())), __LINE__);
        }
        $this->Periodicite = $periodicite;
        return $this;
    }
    /**
     * Get Montant value
     * @return float|null
     */
    public function getMontant()
    {
        return $this->Montant;
    }
    /**
     * Set Montant value
     * @param float $montant
     * @return \CfcalSasieSDK\Entity\Charge
     */
    public function setMontant($montant = null)
    {
        // validation for constraint: float
        if (!is_null($montant) && !(is_float($montant) || is_numeric($montant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant, true), gettype($montant)), __LINE__);
        }
        $this->Montant = $montant;
        return $this;
    }
    /**
     * Get EstPermanente value
     * @return bool|null
     */
    public function getEstPermanente()
    {
        return $this->EstPermanente;
    }
    /**
     * Set EstPermanente value
     * @param bool $estPermanente
     * @return \CfcalSasieSDK\Entity\Charge
     */
    public function setEstPermanente($estPermanente = null)
    {
        // validation for constraint: boolean
        if (!is_null($estPermanente) && !is_bool($estPermanente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estPermanente, true), gettype($estPermanente)), __LINE__);
        }
        $this->EstPermanente = $estPermanente;
        return $this;
    }
    /**
     * Get TypeCharge value
     * @return string|null
     */
    public function getTypeCharge()
    {
        return $this->TypeCharge;
    }
    /**
     * Set TypeCharge value
     * @uses \CfcalSasieSDK\Enum\TypeDeCharge::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeDeCharge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeCharge
     * @return \CfcalSasieSDK\Entity\Charge
     */
    public function setTypeCharge($typeCharge = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeDeCharge::valueIsValid($typeCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeDeCharge', is_array($typeCharge) ? implode(', ', $typeCharge) : var_export($typeCharge, true), implode(', ', \CfcalSasieSDK\Enum\TypeDeCharge::getValidValues())), __LINE__);
        }
        $this->TypeCharge = $typeCharge;
        return $this;
    }
}
