<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cautions Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Cautions
 * @subpackage Structs
 */
class Cautions extends AbstractStructBase
{
    /**
     * The Caution
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Caution[]
     */
    public $Caution;
    /**
     * Constructor method for Cautions
     * @uses Cautions::setCaution()
     * @param \CfcalSasieSDK\Entity\Caution[] $caution
     */
    public function __construct(array $caution = array())
    {
        $this
            ->setCaution($caution);
    }
    /**
     * Get Caution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Caution[]|null
     */
    public function getCaution()
    {
        return isset($this->Caution) ? $this->Caution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCaution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCaution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCautionForArrayConstraintsFromSetCaution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cautionsCautionItem) {
            // validation for constraint: itemType
            if (!$cautionsCautionItem instanceof \CfcalSasieSDK\Entity\Caution) {
                $invalidValues[] = is_object($cautionsCautionItem) ? get_class($cautionsCautionItem) : sprintf('%s(%s)', gettype($cautionsCautionItem), var_export($cautionsCautionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Caution property can only contain items of type \CfcalSasieSDK\Entity\Caution, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Caution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Caution[] $caution
     * @return \CfcalSasieSDK\Entity\Cautions
     */
    public function setCaution(array $caution = array())
    {
        // validation for constraint: array
        if ('' !== ($cautionArrayErrorMessage = self::validateCautionForArrayConstraintsFromSetCaution($caution))) {
            throw new \InvalidArgumentException($cautionArrayErrorMessage, __LINE__);
        }
        if (is_null($caution) || (is_array($caution) && empty($caution))) {
            unset($this->Caution);
        } else {
            $this->Caution = $caution;
        }
        return $this;
    }
    /**
     * Add item to Caution value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Caution $item
     * @return \CfcalSasieSDK\Entity\Cautions
     */
    public function addToCaution(\CfcalSasieSDK\Entity\Caution $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Caution) {
            throw new \InvalidArgumentException(sprintf('The Caution property can only contain items of type \CfcalSasieSDK\Entity\Caution, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Caution[] = $item;
        return $this;
    }
}
