<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CautionHypothecaire Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CautionHypothecaire
 * @subpackage Structs
 */
class CautionHypothecaire extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The IdentifiantIntervenant
     * @var int
     */
    public $IdentifiantIntervenant;
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Nom;
    /**
     * The NomJeuneFille
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomJeuneFille;
    /**
     * The Prenom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Prenom;
    /**
     * The DateNaissance
     * @var string
     */
    public $DateNaissance;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Titre
     * @var string
     */
    public $Titre;
    /**
     * The RegimeMatrimonial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegimeMatrimonial;
    /**
     * The SituationFamiliale
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SituationFamiliale;
    /**
     * The TypeHabitat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TypeHabitat;
    /**
     * The CapaciteJuridique
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CapaciteJuridique;
    /**
     * The Ville
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $Ville;
    /**
     * The VilleNaissance
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $VilleNaissance;
    /**
     * The SituationProfessionnelle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SituationProfessionnelle;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Contacts
     */
    public $Contacts;
    /**
     * Constructor method for CautionHypothecaire
     * @uses CautionHypothecaire::setIdentifiantIntervenant()
     * @uses CautionHypothecaire::setNom()
     * @uses CautionHypothecaire::setNomJeuneFille()
     * @uses CautionHypothecaire::setPrenom()
     * @uses CautionHypothecaire::setDateNaissance()
     * @uses CautionHypothecaire::setAdresse()
     * @uses CautionHypothecaire::setTitre()
     * @uses CautionHypothecaire::setRegimeMatrimonial()
     * @uses CautionHypothecaire::setSituationFamiliale()
     * @uses CautionHypothecaire::setTypeHabitat()
     * @uses CautionHypothecaire::setCapaciteJuridique()
     * @uses CautionHypothecaire::setVille()
     * @uses CautionHypothecaire::setVilleNaissance()
     * @uses CautionHypothecaire::setSituationProfessionnelle()
     * @uses CautionHypothecaire::setContacts()
     * @param int $identifiantIntervenant
     * @param string $nom
     * @param string $nomJeuneFille
     * @param string $prenom
     * @param string $dateNaissance
     * @param string $adresse
     * @param string $titre
     * @param string $regimeMatrimonial
     * @param string $situationFamiliale
     * @param string $typeHabitat
     * @param string $capaciteJuridique
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @param \CfcalSasieSDK\Entity\Ville $villeNaissance
     * @param string $situationProfessionnelle
     * @param \CfcalSasieSDK\Entity\Contacts $contacts
     */
    public function __construct($identifiantIntervenant = null, $nom = null, $nomJeuneFille = null, $prenom = null, $dateNaissance = null, $adresse = null, $titre = null, $regimeMatrimonial = null, $situationFamiliale = null, $typeHabitat = null, $capaciteJuridique = null, \CfcalSasieSDK\Entity\Ville $ville = null, \CfcalSasieSDK\Entity\Ville $villeNaissance = null, $situationProfessionnelle = null, \CfcalSasieSDK\Entity\Contacts $contacts = null)
    {
        $this
            ->setIdentifiantIntervenant($identifiantIntervenant)
            ->setNom($nom)
            ->setNomJeuneFille($nomJeuneFille)
            ->setPrenom($prenom)
            ->setDateNaissance($dateNaissance)
            ->setAdresse($adresse)
            ->setTitre($titre)
            ->setRegimeMatrimonial($regimeMatrimonial)
            ->setSituationFamiliale($situationFamiliale)
            ->setTypeHabitat($typeHabitat)
            ->setCapaciteJuridique($capaciteJuridique)
            ->setVille($ville)
            ->setVilleNaissance($villeNaissance)
            ->setSituationProfessionnelle($situationProfessionnelle)
            ->setContacts($contacts);
    }
    /**
     * Get IdentifiantIntervenant value
     * @return int|null
     */
    public function getIdentifiantIntervenant()
    {
        return $this->IdentifiantIntervenant;
    }
    /**
     * Set IdentifiantIntervenant value
     * @param int $identifiantIntervenant
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setIdentifiantIntervenant($identifiantIntervenant = null)
    {
        // validation for constraint: int
        if (!is_null($identifiantIntervenant) && !(is_int($identifiantIntervenant) || ctype_digit($identifiantIntervenant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identifiantIntervenant, true), gettype($identifiantIntervenant)), __LINE__);
        }
        $this->IdentifiantIntervenant = $identifiantIntervenant;
        return $this;
    }
    /**
     * Get Nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->Nom;
    }
    /**
     * Set Nom value
     * @param string $nom
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->Nom = $nom;
        return $this;
    }
    /**
     * Get NomJeuneFille value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomJeuneFille()
    {
        return isset($this->NomJeuneFille) ? $this->NomJeuneFille : null;
    }
    /**
     * Set NomJeuneFille value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomJeuneFille
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setNomJeuneFille($nomJeuneFille = null)
    {
        // validation for constraint: string
        if (!is_null($nomJeuneFille) && !is_string($nomJeuneFille)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomJeuneFille, true), gettype($nomJeuneFille)), __LINE__);
        }
        if (is_null($nomJeuneFille) || (is_array($nomJeuneFille) && empty($nomJeuneFille))) {
            unset($this->NomJeuneFille);
        } else {
            $this->NomJeuneFille = $nomJeuneFille;
        }
        return $this;
    }
    /**
     * Get Prenom value
     * @return string|null
     */
    public function getPrenom()
    {
        return $this->Prenom;
    }
    /**
     * Set Prenom value
     * @param string $prenom
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setPrenom($prenom = null)
    {
        // validation for constraint: string
        if (!is_null($prenom) && !is_string($prenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prenom, true), gettype($prenom)), __LINE__);
        }
        $this->Prenom = $prenom;
        return $this;
    }
    /**
     * Get DateNaissance value
     * @return string|null
     */
    public function getDateNaissance()
    {
        return $this->DateNaissance;
    }
    /**
     * Set DateNaissance value
     * @param string $dateNaissance
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setDateNaissance($dateNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($dateNaissance) && !is_string($dateNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateNaissance, true), gettype($dateNaissance)), __LINE__);
        }
        $this->DateNaissance = $dateNaissance;
        return $this;
    }
    /**
     * Get Adresse value
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param string $adresse
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse, true), gettype($adresse)), __LINE__);
        }
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get Titre value
     * @return string|null
     */
    public function getTitre()
    {
        return $this->Titre;
    }
    /**
     * Set Titre value
     * @uses \CfcalSasieSDK\Enum\Civilite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Civilite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $titre
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setTitre($titre = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Civilite::valueIsValid($titre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Civilite', is_array($titre) ? implode(', ', $titre) : var_export($titre, true), implode(', ', \CfcalSasieSDK\Enum\Civilite::getValidValues())), __LINE__);
        }
        $this->Titre = $titre;
        return $this;
    }
    /**
     * Get RegimeMatrimonial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegimeMatrimonial()
    {
        return isset($this->RegimeMatrimonial) ? $this->RegimeMatrimonial : null;
    }
    /**
     * Set RegimeMatrimonial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\RegimeMatrimonial::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\RegimeMatrimonial::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regimeMatrimonial
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setRegimeMatrimonial($regimeMatrimonial = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\RegimeMatrimonial::valueIsValid($regimeMatrimonial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\RegimeMatrimonial', is_array($regimeMatrimonial) ? implode(', ', $regimeMatrimonial) : var_export($regimeMatrimonial, true), implode(', ', \CfcalSasieSDK\Enum\RegimeMatrimonial::getValidValues())), __LINE__);
        }
        if (is_null($regimeMatrimonial) || (is_array($regimeMatrimonial) && empty($regimeMatrimonial))) {
            unset($this->RegimeMatrimonial);
        } else {
            $this->RegimeMatrimonial = $regimeMatrimonial;
        }
        return $this;
    }
    /**
     * Get SituationFamiliale value
     * @return string|null
     */
    public function getSituationFamiliale()
    {
        return $this->SituationFamiliale;
    }
    /**
     * Set SituationFamiliale value
     * @uses \CfcalSasieSDK\Enum\SituationFamiliale::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\SituationFamiliale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $situationFamiliale
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setSituationFamiliale($situationFamiliale = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\SituationFamiliale::valueIsValid($situationFamiliale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\SituationFamiliale', is_array($situationFamiliale) ? implode(', ', $situationFamiliale) : var_export($situationFamiliale, true), implode(', ', \CfcalSasieSDK\Enum\SituationFamiliale::getValidValues())), __LINE__);
        }
        $this->SituationFamiliale = $situationFamiliale;
        return $this;
    }
    /**
     * Get TypeHabitat value
     * @return string|null
     */
    public function getTypeHabitat()
    {
        return $this->TypeHabitat;
    }
    /**
     * Set TypeHabitat value
     * @uses \CfcalSasieSDK\Enum\TypeHabitat::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeHabitat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeHabitat
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setTypeHabitat($typeHabitat = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeHabitat::valueIsValid($typeHabitat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeHabitat', is_array($typeHabitat) ? implode(', ', $typeHabitat) : var_export($typeHabitat, true), implode(', ', \CfcalSasieSDK\Enum\TypeHabitat::getValidValues())), __LINE__);
        }
        $this->TypeHabitat = $typeHabitat;
        return $this;
    }
    /**
     * Get CapaciteJuridique value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCapaciteJuridique()
    {
        return isset($this->CapaciteJuridique) ? $this->CapaciteJuridique : null;
    }
    /**
     * Set CapaciteJuridique value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\CapaciteJuridique::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\CapaciteJuridique::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $capaciteJuridique
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setCapaciteJuridique($capaciteJuridique = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\CapaciteJuridique::valueIsValid($capaciteJuridique)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\CapaciteJuridique', is_array($capaciteJuridique) ? implode(', ', $capaciteJuridique) : var_export($capaciteJuridique, true), implode(', ', \CfcalSasieSDK\Enum\CapaciteJuridique::getValidValues())), __LINE__);
        }
        if (is_null($capaciteJuridique) || (is_array($capaciteJuridique) && empty($capaciteJuridique))) {
            unset($this->CapaciteJuridique);
        } else {
            $this->CapaciteJuridique = $capaciteJuridique;
        }
        return $this;
    }
    /**
     * Get Ville value
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setVille(\CfcalSasieSDK\Entity\Ville $ville = null)
    {
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Get VilleNaissance value
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVilleNaissance()
    {
        return $this->VilleNaissance;
    }
    /**
     * Set VilleNaissance value
     * @param \CfcalSasieSDK\Entity\Ville $villeNaissance
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setVilleNaissance(\CfcalSasieSDK\Entity\Ville $villeNaissance = null)
    {
        $this->VilleNaissance = $villeNaissance;
        return $this;
    }
    /**
     * Get SituationProfessionnelle value
     * @return string|null
     */
    public function getSituationProfessionnelle()
    {
        return $this->SituationProfessionnelle;
    }
    /**
     * Set SituationProfessionnelle value
     * @uses \CfcalSasieSDK\Enum\SituationProfessionnelle::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\SituationProfessionnelle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $situationProfessionnelle
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setSituationProfessionnelle($situationProfessionnelle = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\SituationProfessionnelle::valueIsValid($situationProfessionnelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\SituationProfessionnelle', is_array($situationProfessionnelle) ? implode(', ', $situationProfessionnelle) : var_export($situationProfessionnelle, true), implode(', ', \CfcalSasieSDK\Enum\SituationProfessionnelle::getValidValues())), __LINE__);
        }
        $this->SituationProfessionnelle = $situationProfessionnelle;
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Contacts $contacts
     * @return \CfcalSasieSDK\Entity\CautionHypothecaire
     */
    public function setContacts(\CfcalSasieSDK\Entity\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
}
