<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Caution Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Caution
 * @subpackage Structs
 */
class Caution extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeTypeCautionnement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodeTypeCautionnement;
    /**
     * The CodeOrganismeCaution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CodeOrganismeCaution;
    /**
     * The Commentaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Commentaire;
    /**
     * Constructor method for Caution
     * @uses Caution::setCodeTypeCautionnement()
     * @uses Caution::setCodeOrganismeCaution()
     * @uses Caution::setCommentaire()
     * @param int $codeTypeCautionnement
     * @param int $codeOrganismeCaution
     * @param string $commentaire
     */
    public function __construct($codeTypeCautionnement = null, $codeOrganismeCaution = null, $commentaire = null)
    {
        $this
            ->setCodeTypeCautionnement($codeTypeCautionnement)
            ->setCodeOrganismeCaution($codeOrganismeCaution)
            ->setCommentaire($commentaire);
    }
    /**
     * Get CodeTypeCautionnement value
     * @return int|null
     */
    public function getCodeTypeCautionnement()
    {
        return $this->CodeTypeCautionnement;
    }
    /**
     * Set CodeTypeCautionnement value
     * @param int $codeTypeCautionnement
     * @return \CfcalSasieSDK\Entity\Caution
     */
    public function setCodeTypeCautionnement($codeTypeCautionnement = null)
    {
        // validation for constraint: int
        if (!is_null($codeTypeCautionnement) && !(is_int($codeTypeCautionnement) || ctype_digit($codeTypeCautionnement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeTypeCautionnement, true), gettype($codeTypeCautionnement)), __LINE__);
        }
        $this->CodeTypeCautionnement = $codeTypeCautionnement;
        return $this;
    }
    /**
     * Get CodeOrganismeCaution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodeOrganismeCaution()
    {
        return isset($this->CodeOrganismeCaution) ? $this->CodeOrganismeCaution : null;
    }
    /**
     * Set CodeOrganismeCaution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codeOrganismeCaution
     * @return \CfcalSasieSDK\Entity\Caution
     */
    public function setCodeOrganismeCaution($codeOrganismeCaution = null)
    {
        // validation for constraint: int
        if (!is_null($codeOrganismeCaution) && !(is_int($codeOrganismeCaution) || ctype_digit($codeOrganismeCaution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeOrganismeCaution, true), gettype($codeOrganismeCaution)), __LINE__);
        }
        if (is_null($codeOrganismeCaution) || (is_array($codeOrganismeCaution) && empty($codeOrganismeCaution))) {
            unset($this->CodeOrganismeCaution);
        } else {
            $this->CodeOrganismeCaution = $codeOrganismeCaution;
        }
        return $this;
    }
    /**
     * Get Commentaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommentaire()
    {
        return isset($this->Commentaire) ? $this->Commentaire : null;
    }
    /**
     * Set Commentaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commentaire
     * @return \CfcalSasieSDK\Entity\Caution
     */
    public function setCommentaire($commentaire = null)
    {
        // validation for constraint: string
        if (!is_null($commentaire) && !is_string($commentaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentaire, true), gettype($commentaire)), __LINE__);
        }
        if (is_null($commentaire) || (is_array($commentaire) && empty($commentaire))) {
            unset($this->Commentaire);
        } else {
            $this->Commentaire = $commentaire;
        }
        return $this;
    }
}
