<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bien Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Bien
 * @subpackage Structs
 */
class Bien extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Categorie
     * @var string
     */
    public $Categorie;
    /**
     * The Etage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Etage;
    /**
     * The JustificatifSurface
     * @var string
     */
    public $JustificatifSurface;
    /**
     * The Surface
     * @var float
     */
    public $Surface;
    /**
     * The EstCollectif
     * @var bool
     */
    public $EstCollectif;
    /**
     * The TypeBien
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TypeBien;
    /**
     * The Standing
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Standing;
    /**
     * The AnneeDeConstruction
     * @var int
     */
    public $AnneeDeConstruction;
    /**
     * The PrixAcquisition
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\PrixAcquisitionBien
     */
    public $PrixAcquisition;
    /**
     * The EstimationRecente
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\EstimationRecenteBien
     */
    public $EstimationRecente;
    /**
     * The DescriptionsBiens
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\DescriptionBiens
     */
    public $DescriptionsBiens;
    /**
     * The CoproprieteBiens
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\CoproprieteBiens
     */
    public $CoproprieteBiens;
    /**
     * The EstAtypique
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstAtypique;
    /**
     * The MontantTravauxAFinancer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MontantTravauxAFinancer;
    /**
     * The MontantTravauxEffectue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MontantTravauxEffectue;
    /**
     * The MontantPlusValueEstimee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MontantPlusValueEstimee;
    /**
     * The CodeTypePeriodiciteLoyer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypePeriodiciteLoyer;
    /**
     * The LoyerHorsCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LoyerHorsCharge;
    /**
     * The ChargeLoyer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ChargeLoyer;
    /**
     * The CodeTypeSousCategorie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeSousCategorie;
    /**
     * The CodeTypeDestination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CodeTypeDestination;
    /**
     * The CodeTypeChargesReelles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeChargesReelles;
    /**
     * The CodeTypeModeAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeModeAcquisition;
    /**
     * The CodeTypeEtatBien
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeEtatBien;
    /**
     * The CodeTypeClassificationBien
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeClassificationBien;
    /**
     * Constructor method for Bien
     * @uses Bien::setCategorie()
     * @uses Bien::setEtage()
     * @uses Bien::setJustificatifSurface()
     * @uses Bien::setSurface()
     * @uses Bien::setEstCollectif()
     * @uses Bien::setTypeBien()
     * @uses Bien::setStanding()
     * @uses Bien::setAnneeDeConstruction()
     * @uses Bien::setPrixAcquisition()
     * @uses Bien::setEstimationRecente()
     * @uses Bien::setDescriptionsBiens()
     * @uses Bien::setCoproprieteBiens()
     * @uses Bien::setEstAtypique()
     * @uses Bien::setMontantTravauxAFinancer()
     * @uses Bien::setMontantTravauxEffectue()
     * @uses Bien::setMontantPlusValueEstimee()
     * @uses Bien::setCodeTypePeriodiciteLoyer()
     * @uses Bien::setLoyerHorsCharge()
     * @uses Bien::setChargeLoyer()
     * @uses Bien::setCodeTypeSousCategorie()
     * @uses Bien::setCodeTypeDestination()
     * @uses Bien::setCodeTypeChargesReelles()
     * @uses Bien::setCodeTypeModeAcquisition()
     * @uses Bien::setCodeTypeEtatBien()
     * @uses Bien::setCodeTypeClassificationBien()
     * @param string $categorie
     * @param int $etage
     * @param string $justificatifSurface
     * @param float $surface
     * @param bool $estCollectif
     * @param string $typeBien
     * @param string $standing
     * @param int $anneeDeConstruction
     * @param \CfcalSasieSDK\Entity\PrixAcquisitionBien $prixAcquisition
     * @param \CfcalSasieSDK\Entity\EstimationRecenteBien $estimationRecente
     * @param \CfcalSasieSDK\Entity\DescriptionBiens $descriptionsBiens
     * @param \CfcalSasieSDK\Entity\CoproprieteBiens $coproprieteBiens
     * @param bool $estAtypique
     * @param float $montantTravauxAFinancer
     * @param float $montantTravauxEffectue
     * @param float $montantPlusValueEstimee
     * @param string $codeTypePeriodiciteLoyer
     * @param float $loyerHorsCharge
     * @param float $chargeLoyer
     * @param string $codeTypeSousCategorie
     * @param string[] $codeTypeDestination
     * @param string $codeTypeChargesReelles
     * @param string $codeTypeModeAcquisition
     * @param string $codeTypeEtatBien
     * @param string $codeTypeClassificationBien
     */
    public function __construct($categorie = null, $etage = null, $justificatifSurface = null, $surface = null, $estCollectif = null, $typeBien = null, $standing = null, $anneeDeConstruction = null, \CfcalSasieSDK\Entity\PrixAcquisitionBien $prixAcquisition = null, \CfcalSasieSDK\Entity\EstimationRecenteBien $estimationRecente = null, \CfcalSasieSDK\Entity\DescriptionBiens $descriptionsBiens = null, \CfcalSasieSDK\Entity\CoproprieteBiens $coproprieteBiens = null, $estAtypique = null, $montantTravauxAFinancer = null, $montantTravauxEffectue = null, $montantPlusValueEstimee = null, $codeTypePeriodiciteLoyer = null, $loyerHorsCharge = null, $chargeLoyer = null, $codeTypeSousCategorie = null, array $codeTypeDestination = array(), $codeTypeChargesReelles = null, $codeTypeModeAcquisition = null, $codeTypeEtatBien = null, $codeTypeClassificationBien = null)
    {
        $this
            ->setCategorie($categorie)
            ->setEtage($etage)
            ->setJustificatifSurface($justificatifSurface)
            ->setSurface($surface)
            ->setEstCollectif($estCollectif)
            ->setTypeBien($typeBien)
            ->setStanding($standing)
            ->setAnneeDeConstruction($anneeDeConstruction)
            ->setPrixAcquisition($prixAcquisition)
            ->setEstimationRecente($estimationRecente)
            ->setDescriptionsBiens($descriptionsBiens)
            ->setCoproprieteBiens($coproprieteBiens)
            ->setEstAtypique($estAtypique)
            ->setMontantTravauxAFinancer($montantTravauxAFinancer)
            ->setMontantTravauxEffectue($montantTravauxEffectue)
            ->setMontantPlusValueEstimee($montantPlusValueEstimee)
            ->setCodeTypePeriodiciteLoyer($codeTypePeriodiciteLoyer)
            ->setLoyerHorsCharge($loyerHorsCharge)
            ->setChargeLoyer($chargeLoyer)
            ->setCodeTypeSousCategorie($codeTypeSousCategorie)
            ->setCodeTypeDestination($codeTypeDestination)
            ->setCodeTypeChargesReelles($codeTypeChargesReelles)
            ->setCodeTypeModeAcquisition($codeTypeModeAcquisition)
            ->setCodeTypeEtatBien($codeTypeEtatBien)
            ->setCodeTypeClassificationBien($codeTypeClassificationBien);
    }
    /**
     * Get Categorie value
     * @return string|null
     */
    public function getCategorie()
    {
        return $this->Categorie;
    }
    /**
     * Set Categorie value
     * @uses \CfcalSasieSDK\Enum\TypeCategorieBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeCategorieBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categorie
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCategorie($categorie = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeCategorieBien::valueIsValid($categorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeCategorieBien', is_array($categorie) ? implode(', ', $categorie) : var_export($categorie, true), implode(', ', \CfcalSasieSDK\Enum\TypeCategorieBien::getValidValues())), __LINE__);
        }
        $this->Categorie = $categorie;
        return $this;
    }
    /**
     * Get Etage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEtage()
    {
        return isset($this->Etage) ? $this->Etage : null;
    }
    /**
     * Set Etage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $etage
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setEtage($etage = null)
    {
        // validation for constraint: int
        if (!is_null($etage) && !(is_int($etage) || ctype_digit($etage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($etage, true), gettype($etage)), __LINE__);
        }
        if (is_null($etage) || (is_array($etage) && empty($etage))) {
            unset($this->Etage);
        } else {
            $this->Etage = $etage;
        }
        return $this;
    }
    /**
     * Get JustificatifSurface value
     * @return string|null
     */
    public function getJustificatifSurface()
    {
        return $this->JustificatifSurface;
    }
    /**
     * Set JustificatifSurface value
     * @uses \CfcalSasieSDK\Enum\TypeJustificatifSurface::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeJustificatifSurface::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $justificatifSurface
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setJustificatifSurface($justificatifSurface = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeJustificatifSurface::valueIsValid($justificatifSurface)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeJustificatifSurface', is_array($justificatifSurface) ? implode(', ', $justificatifSurface) : var_export($justificatifSurface, true), implode(', ', \CfcalSasieSDK\Enum\TypeJustificatifSurface::getValidValues())), __LINE__);
        }
        $this->JustificatifSurface = $justificatifSurface;
        return $this;
    }
    /**
     * Get Surface value
     * @return float|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param float $surface
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setSurface($surface = null)
    {
        // validation for constraint: float
        if (!is_null($surface) && !(is_float($surface) || is_numeric($surface))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surface, true), gettype($surface)), __LINE__);
        }
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get EstCollectif value
     * @return bool|null
     */
    public function getEstCollectif()
    {
        return $this->EstCollectif;
    }
    /**
     * Set EstCollectif value
     * @param bool $estCollectif
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setEstCollectif($estCollectif = null)
    {
        // validation for constraint: boolean
        if (!is_null($estCollectif) && !is_bool($estCollectif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estCollectif, true), gettype($estCollectif)), __LINE__);
        }
        $this->EstCollectif = $estCollectif;
        return $this;
    }
    /**
     * Get TypeBien value
     * @return string|null
     */
    public function getTypeBien()
    {
        return $this->TypeBien;
    }
    /**
     * Set TypeBien value
     * @uses \CfcalSasieSDK\Enum\TypeBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeBien
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setTypeBien($typeBien = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeBien::valueIsValid($typeBien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeBien', is_array($typeBien) ? implode(', ', $typeBien) : var_export($typeBien, true), implode(', ', \CfcalSasieSDK\Enum\TypeBien::getValidValues())), __LINE__);
        }
        $this->TypeBien = $typeBien;
        return $this;
    }
    /**
     * Get Standing value
     * @return string|null
     */
    public function getStanding()
    {
        return $this->Standing;
    }
    /**
     * Set Standing value
     * @uses \CfcalSasieSDK\Enum\Standing::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Standing::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $standing
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setStanding($standing = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Standing::valueIsValid($standing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Standing', is_array($standing) ? implode(', ', $standing) : var_export($standing, true), implode(', ', \CfcalSasieSDK\Enum\Standing::getValidValues())), __LINE__);
        }
        $this->Standing = $standing;
        return $this;
    }
    /**
     * Get AnneeDeConstruction value
     * @return int|null
     */
    public function getAnneeDeConstruction()
    {
        return $this->AnneeDeConstruction;
    }
    /**
     * Set AnneeDeConstruction value
     * @param int $anneeDeConstruction
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setAnneeDeConstruction($anneeDeConstruction = null)
    {
        // validation for constraint: int
        if (!is_null($anneeDeConstruction) && !(is_int($anneeDeConstruction) || ctype_digit($anneeDeConstruction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anneeDeConstruction, true), gettype($anneeDeConstruction)), __LINE__);
        }
        $this->AnneeDeConstruction = $anneeDeConstruction;
        return $this;
    }
    /**
     * Get PrixAcquisition value
     * @return \CfcalSasieSDK\Entity\PrixAcquisitionBien|null
     */
    public function getPrixAcquisition()
    {
        return $this->PrixAcquisition;
    }
    /**
     * Set PrixAcquisition value
     * @param \CfcalSasieSDK\Entity\PrixAcquisitionBien $prixAcquisition
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setPrixAcquisition(\CfcalSasieSDK\Entity\PrixAcquisitionBien $prixAcquisition = null)
    {
        $this->PrixAcquisition = $prixAcquisition;
        return $this;
    }
    /**
     * Get EstimationRecente value
     * @return \CfcalSasieSDK\Entity\EstimationRecenteBien|null
     */
    public function getEstimationRecente()
    {
        return $this->EstimationRecente;
    }
    /**
     * Set EstimationRecente value
     * @param \CfcalSasieSDK\Entity\EstimationRecenteBien $estimationRecente
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setEstimationRecente(\CfcalSasieSDK\Entity\EstimationRecenteBien $estimationRecente = null)
    {
        $this->EstimationRecente = $estimationRecente;
        return $this;
    }
    /**
     * Get DescriptionsBiens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\DescriptionBiens|null
     */
    public function getDescriptionsBiens()
    {
        return isset($this->DescriptionsBiens) ? $this->DescriptionsBiens : null;
    }
    /**
     * Set DescriptionsBiens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\DescriptionBiens $descriptionsBiens
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setDescriptionsBiens(\CfcalSasieSDK\Entity\DescriptionBiens $descriptionsBiens = null)
    {
        if (is_null($descriptionsBiens) || (is_array($descriptionsBiens) && empty($descriptionsBiens))) {
            unset($this->DescriptionsBiens);
        } else {
            $this->DescriptionsBiens = $descriptionsBiens;
        }
        return $this;
    }
    /**
     * Get CoproprieteBiens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\CoproprieteBiens|null
     */
    public function getCoproprieteBiens()
    {
        return isset($this->CoproprieteBiens) ? $this->CoproprieteBiens : null;
    }
    /**
     * Set CoproprieteBiens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\CoproprieteBiens $coproprieteBiens
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCoproprieteBiens(\CfcalSasieSDK\Entity\CoproprieteBiens $coproprieteBiens = null)
    {
        if (is_null($coproprieteBiens) || (is_array($coproprieteBiens) && empty($coproprieteBiens))) {
            unset($this->CoproprieteBiens);
        } else {
            $this->CoproprieteBiens = $coproprieteBiens;
        }
        return $this;
    }
    /**
     * Get EstAtypique value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstAtypique()
    {
        return isset($this->EstAtypique) ? $this->EstAtypique : null;
    }
    /**
     * Set EstAtypique value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estAtypique
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setEstAtypique($estAtypique = null)
    {
        // validation for constraint: boolean
        if (!is_null($estAtypique) && !is_bool($estAtypique)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estAtypique, true), gettype($estAtypique)), __LINE__);
        }
        if (is_null($estAtypique) || (is_array($estAtypique) && empty($estAtypique))) {
            unset($this->EstAtypique);
        } else {
            $this->EstAtypique = $estAtypique;
        }
        return $this;
    }
    /**
     * Get MontantTravauxAFinancer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMontantTravauxAFinancer()
    {
        return isset($this->MontantTravauxAFinancer) ? $this->MontantTravauxAFinancer : null;
    }
    /**
     * Set MontantTravauxAFinancer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $montantTravauxAFinancer
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setMontantTravauxAFinancer($montantTravauxAFinancer = null)
    {
        // validation for constraint: float
        if (!is_null($montantTravauxAFinancer) && !(is_float($montantTravauxAFinancer) || is_numeric($montantTravauxAFinancer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantTravauxAFinancer, true), gettype($montantTravauxAFinancer)), __LINE__);
        }
        if (is_null($montantTravauxAFinancer) || (is_array($montantTravauxAFinancer) && empty($montantTravauxAFinancer))) {
            unset($this->MontantTravauxAFinancer);
        } else {
            $this->MontantTravauxAFinancer = $montantTravauxAFinancer;
        }
        return $this;
    }
    /**
     * Get MontantTravauxEffectue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMontantTravauxEffectue()
    {
        return isset($this->MontantTravauxEffectue) ? $this->MontantTravauxEffectue : null;
    }
    /**
     * Set MontantTravauxEffectue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $montantTravauxEffectue
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setMontantTravauxEffectue($montantTravauxEffectue = null)
    {
        // validation for constraint: float
        if (!is_null($montantTravauxEffectue) && !(is_float($montantTravauxEffectue) || is_numeric($montantTravauxEffectue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantTravauxEffectue, true), gettype($montantTravauxEffectue)), __LINE__);
        }
        if (is_null($montantTravauxEffectue) || (is_array($montantTravauxEffectue) && empty($montantTravauxEffectue))) {
            unset($this->MontantTravauxEffectue);
        } else {
            $this->MontantTravauxEffectue = $montantTravauxEffectue;
        }
        return $this;
    }
    /**
     * Get MontantPlusValueEstimee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMontantPlusValueEstimee()
    {
        return isset($this->MontantPlusValueEstimee) ? $this->MontantPlusValueEstimee : null;
    }
    /**
     * Set MontantPlusValueEstimee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $montantPlusValueEstimee
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setMontantPlusValueEstimee($montantPlusValueEstimee = null)
    {
        // validation for constraint: float
        if (!is_null($montantPlusValueEstimee) && !(is_float($montantPlusValueEstimee) || is_numeric($montantPlusValueEstimee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantPlusValueEstimee, true), gettype($montantPlusValueEstimee)), __LINE__);
        }
        if (is_null($montantPlusValueEstimee) || (is_array($montantPlusValueEstimee) && empty($montantPlusValueEstimee))) {
            unset($this->MontantPlusValueEstimee);
        } else {
            $this->MontantPlusValueEstimee = $montantPlusValueEstimee;
        }
        return $this;
    }
    /**
     * Get CodeTypePeriodiciteLoyer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypePeriodiciteLoyer()
    {
        return isset($this->CodeTypePeriodiciteLoyer) ? $this->CodeTypePeriodiciteLoyer : null;
    }
    /**
     * Set CodeTypePeriodiciteLoyer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\Periodicite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Periodicite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypePeriodiciteLoyer
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCodeTypePeriodiciteLoyer($codeTypePeriodiciteLoyer = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Periodicite::valueIsValid($codeTypePeriodiciteLoyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Periodicite', is_array($codeTypePeriodiciteLoyer) ? implode(', ', $codeTypePeriodiciteLoyer) : var_export($codeTypePeriodiciteLoyer, true), implode(', ', \CfcalSasieSDK\Enum\Periodicite::getValidValues())), __LINE__);
        }
        if (is_null($codeTypePeriodiciteLoyer) || (is_array($codeTypePeriodiciteLoyer) && empty($codeTypePeriodiciteLoyer))) {
            unset($this->CodeTypePeriodiciteLoyer);
        } else {
            $this->CodeTypePeriodiciteLoyer = $codeTypePeriodiciteLoyer;
        }
        return $this;
    }
    /**
     * Get LoyerHorsCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLoyerHorsCharge()
    {
        return isset($this->LoyerHorsCharge) ? $this->LoyerHorsCharge : null;
    }
    /**
     * Set LoyerHorsCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $loyerHorsCharge
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setLoyerHorsCharge($loyerHorsCharge = null)
    {
        // validation for constraint: float
        if (!is_null($loyerHorsCharge) && !(is_float($loyerHorsCharge) || is_numeric($loyerHorsCharge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyerHorsCharge, true), gettype($loyerHorsCharge)), __LINE__);
        }
        if (is_null($loyerHorsCharge) || (is_array($loyerHorsCharge) && empty($loyerHorsCharge))) {
            unset($this->LoyerHorsCharge);
        } else {
            $this->LoyerHorsCharge = $loyerHorsCharge;
        }
        return $this;
    }
    /**
     * Get ChargeLoyer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getChargeLoyer()
    {
        return isset($this->ChargeLoyer) ? $this->ChargeLoyer : null;
    }
    /**
     * Set ChargeLoyer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $chargeLoyer
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setChargeLoyer($chargeLoyer = null)
    {
        // validation for constraint: float
        if (!is_null($chargeLoyer) && !(is_float($chargeLoyer) || is_numeric($chargeLoyer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeLoyer, true), gettype($chargeLoyer)), __LINE__);
        }
        if (is_null($chargeLoyer) || (is_array($chargeLoyer) && empty($chargeLoyer))) {
            unset($this->ChargeLoyer);
        } else {
            $this->ChargeLoyer = $chargeLoyer;
        }
        return $this;
    }
    /**
     * Get CodeTypeSousCategorie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeSousCategorie()
    {
        return isset($this->CodeTypeSousCategorie) ? $this->CodeTypeSousCategorie : null;
    }
    /**
     * Set CodeTypeSousCategorie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeSousCategorieBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeSousCategorieBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeSousCategorie
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCodeTypeSousCategorie($codeTypeSousCategorie = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeSousCategorieBien::valueIsValid($codeTypeSousCategorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeSousCategorieBien', is_array($codeTypeSousCategorie) ? implode(', ', $codeTypeSousCategorie) : var_export($codeTypeSousCategorie, true), implode(', ', \CfcalSasieSDK\Enum\TypeSousCategorieBien::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeSousCategorie) || (is_array($codeTypeSousCategorie) && empty($codeTypeSousCategorie))) {
            unset($this->CodeTypeSousCategorie);
        } else {
            $this->CodeTypeSousCategorie = $codeTypeSousCategorie;
        }
        return $this;
    }
    /**
     * Get CodeTypeDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCodeTypeDestination()
    {
        return isset($this->CodeTypeDestination) ? $this->CodeTypeDestination : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCodeTypeDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodeTypeDestination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeTypeDestinationForArrayConstraintsFromSetCodeTypeDestination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bienCodeTypeDestinationItem) {
            // validation for constraint: enumeration
            if (!\CfcalSasieSDK\Enum\TypeDestinationBien::valueIsValid($bienCodeTypeDestinationItem)) {
                $invalidValues[] = is_object($bienCodeTypeDestinationItem) ? get_class($bienCodeTypeDestinationItem) : sprintf('%s(%s)', gettype($bienCodeTypeDestinationItem), var_export($bienCodeTypeDestinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeDestinationBien', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CfcalSasieSDK\Enum\TypeDestinationBien::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CodeTypeDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeDestinationBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeDestinationBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $codeTypeDestination
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCodeTypeDestination(array $codeTypeDestination = array())
    {
        // validation for constraint: list
        if ('' !== ($codeTypeDestinationArrayErrorMessage = self::validateCodeTypeDestinationForArrayConstraintsFromSetCodeTypeDestination($codeTypeDestination))) {
            throw new \InvalidArgumentException($codeTypeDestinationArrayErrorMessage, __LINE__);
        }
        if (is_null($codeTypeDestination) || (is_array($codeTypeDestination) && empty($codeTypeDestination))) {
            unset($this->CodeTypeDestination);
        } else {
            $this->CodeTypeDestination = is_array($codeTypeDestination) ? implode(' ', $codeTypeDestination) : null;
        }
        return $this;
    }
    /**
     * Get CodeTypeChargesReelles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeChargesReelles()
    {
        return isset($this->CodeTypeChargesReelles) ? $this->CodeTypeChargesReelles : null;
    }
    /**
     * Set CodeTypeChargesReelles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\ChargesReelles::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\ChargesReelles::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeChargesReelles
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCodeTypeChargesReelles($codeTypeChargesReelles = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\ChargesReelles::valueIsValid($codeTypeChargesReelles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\ChargesReelles', is_array($codeTypeChargesReelles) ? implode(', ', $codeTypeChargesReelles) : var_export($codeTypeChargesReelles, true), implode(', ', \CfcalSasieSDK\Enum\ChargesReelles::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeChargesReelles) || (is_array($codeTypeChargesReelles) && empty($codeTypeChargesReelles))) {
            unset($this->CodeTypeChargesReelles);
        } else {
            $this->CodeTypeChargesReelles = $codeTypeChargesReelles;
        }
        return $this;
    }
    /**
     * Get CodeTypeModeAcquisition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeModeAcquisition()
    {
        return isset($this->CodeTypeModeAcquisition) ? $this->CodeTypeModeAcquisition : null;
    }
    /**
     * Set CodeTypeModeAcquisition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\ModeAcquisition::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\ModeAcquisition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeModeAcquisition
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCodeTypeModeAcquisition($codeTypeModeAcquisition = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\ModeAcquisition::valueIsValid($codeTypeModeAcquisition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\ModeAcquisition', is_array($codeTypeModeAcquisition) ? implode(', ', $codeTypeModeAcquisition) : var_export($codeTypeModeAcquisition, true), implode(', ', \CfcalSasieSDK\Enum\ModeAcquisition::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeModeAcquisition) || (is_array($codeTypeModeAcquisition) && empty($codeTypeModeAcquisition))) {
            unset($this->CodeTypeModeAcquisition);
        } else {
            $this->CodeTypeModeAcquisition = $codeTypeModeAcquisition;
        }
        return $this;
    }
    /**
     * Get CodeTypeEtatBien value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeEtatBien()
    {
        return isset($this->CodeTypeEtatBien) ? $this->CodeTypeEtatBien : null;
    }
    /**
     * Set CodeTypeEtatBien value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeEtatBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeEtatBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeEtatBien
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCodeTypeEtatBien($codeTypeEtatBien = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeEtatBien::valueIsValid($codeTypeEtatBien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeEtatBien', is_array($codeTypeEtatBien) ? implode(', ', $codeTypeEtatBien) : var_export($codeTypeEtatBien, true), implode(', ', \CfcalSasieSDK\Enum\TypeEtatBien::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeEtatBien) || (is_array($codeTypeEtatBien) && empty($codeTypeEtatBien))) {
            unset($this->CodeTypeEtatBien);
        } else {
            $this->CodeTypeEtatBien = $codeTypeEtatBien;
        }
        return $this;
    }
    /**
     * Get CodeTypeClassificationBien value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeClassificationBien()
    {
        return isset($this->CodeTypeClassificationBien) ? $this->CodeTypeClassificationBien : null;
    }
    /**
     * Set CodeTypeClassificationBien value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeClassificationBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeClassificationBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeClassificationBien
     * @return \CfcalSasieSDK\Entity\Bien
     */
    public function setCodeTypeClassificationBien($codeTypeClassificationBien = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeClassificationBien::valueIsValid($codeTypeClassificationBien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeClassificationBien', is_array($codeTypeClassificationBien) ? implode(', ', $codeTypeClassificationBien) : var_export($codeTypeClassificationBien, true), implode(', ', \CfcalSasieSDK\Enum\TypeClassificationBien::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeClassificationBien) || (is_array($codeTypeClassificationBien) && empty($codeTypeClassificationBien))) {
            unset($this->CodeTypeClassificationBien);
        } else {
            $this->CodeTypeClassificationBien = $codeTypeClassificationBien;
        }
        return $this;
    }
}
