<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assurance Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Assurance
 * @subpackage Structs
 */
class Assurance extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeAssureur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodeAssureur;
    /**
     * The Part
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Part;
    /**
     * The Prime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Prime;
    /**
     * The CodeTypeAssurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeAssurance;
    /**
     * The CodeTypePeriodiciteAssurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypePeriodiciteAssurance;
    /**
     * The EstPrimeUniquePreleveeALActe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstPrimeUniquePreleveeALActe;
    /**
     * The Montant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Montant;
    /**
     * The CodeTypeCapitalAssurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeCapitalAssurance;
    /**
     * Constructor method for Assurance
     * @uses Assurance::setCodeAssureur()
     * @uses Assurance::setPart()
     * @uses Assurance::setPrime()
     * @uses Assurance::setCodeTypeAssurance()
     * @uses Assurance::setCodeTypePeriodiciteAssurance()
     * @uses Assurance::setEstPrimeUniquePreleveeALActe()
     * @uses Assurance::setMontant()
     * @uses Assurance::setCodeTypeCapitalAssurance()
     * @param int $codeAssureur
     * @param float $part
     * @param float $prime
     * @param string $codeTypeAssurance
     * @param string $codeTypePeriodiciteAssurance
     * @param bool $estPrimeUniquePreleveeALActe
     * @param float $montant
     * @param string $codeTypeCapitalAssurance
     */
    public function __construct($codeAssureur = null, $part = null, $prime = null, $codeTypeAssurance = null, $codeTypePeriodiciteAssurance = null, $estPrimeUniquePreleveeALActe = null, $montant = null, $codeTypeCapitalAssurance = null)
    {
        $this
            ->setCodeAssureur($codeAssureur)
            ->setPart($part)
            ->setPrime($prime)
            ->setCodeTypeAssurance($codeTypeAssurance)
            ->setCodeTypePeriodiciteAssurance($codeTypePeriodiciteAssurance)
            ->setEstPrimeUniquePreleveeALActe($estPrimeUniquePreleveeALActe)
            ->setMontant($montant)
            ->setCodeTypeCapitalAssurance($codeTypeCapitalAssurance);
    }
    /**
     * Get CodeAssureur value
     * @return int|null
     */
    public function getCodeAssureur()
    {
        return $this->CodeAssureur;
    }
    /**
     * Set CodeAssureur value
     * @param int $codeAssureur
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setCodeAssureur($codeAssureur = null)
    {
        // validation for constraint: int
        if (!is_null($codeAssureur) && !(is_int($codeAssureur) || ctype_digit($codeAssureur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeAssureur, true), gettype($codeAssureur)), __LINE__);
        }
        $this->CodeAssureur = $codeAssureur;
        return $this;
    }
    /**
     * Get Part value
     * @return float|null
     */
    public function getPart()
    {
        return $this->Part;
    }
    /**
     * Set Part value
     * @param float $part
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setPart($part = null)
    {
        // validation for constraint: float
        if (!is_null($part) && !(is_float($part) || is_numeric($part))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($part, true), gettype($part)), __LINE__);
        }
        $this->Part = $part;
        return $this;
    }
    /**
     * Get Prime value
     * @return float|null
     */
    public function getPrime()
    {
        return $this->Prime;
    }
    /**
     * Set Prime value
     * @param float $prime
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setPrime($prime = null)
    {
        // validation for constraint: float
        if (!is_null($prime) && !(is_float($prime) || is_numeric($prime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prime, true), gettype($prime)), __LINE__);
        }
        $this->Prime = $prime;
        return $this;
    }
    /**
     * Get CodeTypeAssurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeAssurance()
    {
        return isset($this->CodeTypeAssurance) ? $this->CodeTypeAssurance : null;
    }
    /**
     * Set CodeTypeAssurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeAssurance::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeAssurance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeAssurance
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setCodeTypeAssurance($codeTypeAssurance = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeAssurance::valueIsValid($codeTypeAssurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeAssurance', is_array($codeTypeAssurance) ? implode(', ', $codeTypeAssurance) : var_export($codeTypeAssurance, true), implode(', ', \CfcalSasieSDK\Enum\TypeAssurance::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeAssurance) || (is_array($codeTypeAssurance) && empty($codeTypeAssurance))) {
            unset($this->CodeTypeAssurance);
        } else {
            $this->CodeTypeAssurance = $codeTypeAssurance;
        }
        return $this;
    }
    /**
     * Get CodeTypePeriodiciteAssurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypePeriodiciteAssurance()
    {
        return isset($this->CodeTypePeriodiciteAssurance) ? $this->CodeTypePeriodiciteAssurance : null;
    }
    /**
     * Set CodeTypePeriodiciteAssurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypePeriodiciteAssurance::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypePeriodiciteAssurance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypePeriodiciteAssurance
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setCodeTypePeriodiciteAssurance($codeTypePeriodiciteAssurance = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypePeriodiciteAssurance::valueIsValid($codeTypePeriodiciteAssurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypePeriodiciteAssurance', is_array($codeTypePeriodiciteAssurance) ? implode(', ', $codeTypePeriodiciteAssurance) : var_export($codeTypePeriodiciteAssurance, true), implode(', ', \CfcalSasieSDK\Enum\TypePeriodiciteAssurance::getValidValues())), __LINE__);
        }
        if (is_null($codeTypePeriodiciteAssurance) || (is_array($codeTypePeriodiciteAssurance) && empty($codeTypePeriodiciteAssurance))) {
            unset($this->CodeTypePeriodiciteAssurance);
        } else {
            $this->CodeTypePeriodiciteAssurance = $codeTypePeriodiciteAssurance;
        }
        return $this;
    }
    /**
     * Get EstPrimeUniquePreleveeALActe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstPrimeUniquePreleveeALActe()
    {
        return isset($this->EstPrimeUniquePreleveeALActe) ? $this->EstPrimeUniquePreleveeALActe : null;
    }
    /**
     * Set EstPrimeUniquePreleveeALActe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estPrimeUniquePreleveeALActe
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setEstPrimeUniquePreleveeALActe($estPrimeUniquePreleveeALActe = null)
    {
        // validation for constraint: boolean
        if (!is_null($estPrimeUniquePreleveeALActe) && !is_bool($estPrimeUniquePreleveeALActe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estPrimeUniquePreleveeALActe, true), gettype($estPrimeUniquePreleveeALActe)), __LINE__);
        }
        if (is_null($estPrimeUniquePreleveeALActe) || (is_array($estPrimeUniquePreleveeALActe) && empty($estPrimeUniquePreleveeALActe))) {
            unset($this->EstPrimeUniquePreleveeALActe);
        } else {
            $this->EstPrimeUniquePreleveeALActe = $estPrimeUniquePreleveeALActe;
        }
        return $this;
    }
    /**
     * Get Montant value
     * @return float|null
     */
    public function getMontant()
    {
        return $this->Montant;
    }
    /**
     * Set Montant value
     * @param float $montant
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setMontant($montant = null)
    {
        // validation for constraint: float
        if (!is_null($montant) && !(is_float($montant) || is_numeric($montant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant, true), gettype($montant)), __LINE__);
        }
        $this->Montant = $montant;
        return $this;
    }
    /**
     * Get CodeTypeCapitalAssurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeCapitalAssurance()
    {
        return isset($this->CodeTypeCapitalAssurance) ? $this->CodeTypeCapitalAssurance : null;
    }
    /**
     * Set CodeTypeCapitalAssurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeCapitalAssurance::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeCapitalAssurance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeCapitalAssurance
     * @return \CfcalSasieSDK\Entity\Assurance
     */
    public function setCodeTypeCapitalAssurance($codeTypeCapitalAssurance = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeCapitalAssurance::valueIsValid($codeTypeCapitalAssurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeCapitalAssurance', is_array($codeTypeCapitalAssurance) ? implode(', ', $codeTypeCapitalAssurance) : var_export($codeTypeCapitalAssurance, true), implode(', ', \CfcalSasieSDK\Enum\TypeCapitalAssurance::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeCapitalAssurance) || (is_array($codeTypeCapitalAssurance) && empty($codeTypeCapitalAssurance))) {
            unset($this->CodeTypeCapitalAssurance);
        } else {
            $this->CodeTypeCapitalAssurance = $codeTypeCapitalAssurance;
        }
        return $this;
    }
}
