<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Acquisitions Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Acquisitions
 * @subpackage Structs
 */
class Acquisitions extends AbstractStructBase
{
    /**
     * The Acquisition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Acquisition[]
     */
    public $Acquisition;
    /**
     * Constructor method for Acquisitions
     * @uses Acquisitions::setAcquisition()
     * @param \CfcalSasieSDK\Entity\Acquisition[] $acquisition
     */
    public function __construct(array $acquisition = array())
    {
        $this
            ->setAcquisition($acquisition);
    }
    /**
     * Get Acquisition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Acquisition[]|null
     */
    public function getAcquisition()
    {
        return isset($this->Acquisition) ? $this->Acquisition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAcquisition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcquisition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcquisitionForArrayConstraintsFromSetAcquisition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acquisitionsAcquisitionItem) {
            // validation for constraint: itemType
            if (!$acquisitionsAcquisitionItem instanceof \CfcalSasieSDK\Entity\Acquisition) {
                $invalidValues[] = is_object($acquisitionsAcquisitionItem) ? get_class($acquisitionsAcquisitionItem) : sprintf('%s(%s)', gettype($acquisitionsAcquisitionItem), var_export($acquisitionsAcquisitionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Acquisition property can only contain items of type \CfcalSasieSDK\Entity\Acquisition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Acquisition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Acquisition[] $acquisition
     * @return \CfcalSasieSDK\Entity\Acquisitions
     */
    public function setAcquisition(array $acquisition = array())
    {
        // validation for constraint: array
        if ('' !== ($acquisitionArrayErrorMessage = self::validateAcquisitionForArrayConstraintsFromSetAcquisition($acquisition))) {
            throw new \InvalidArgumentException($acquisitionArrayErrorMessage, __LINE__);
        }
        if (is_null($acquisition) || (is_array($acquisition) && empty($acquisition))) {
            unset($this->Acquisition);
        } else {
            $this->Acquisition = $acquisition;
        }
        return $this;
    }
    /**
     * Add item to Acquisition value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Acquisition $item
     * @return \CfcalSasieSDK\Entity\Acquisitions
     */
    public function addToAcquisition(\CfcalSasieSDK\Entity\Acquisition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Acquisition) {
            throw new \InvalidArgumentException(sprintf('The Acquisition property can only contain items of type \CfcalSasieSDK\Entity\Acquisition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Acquisition[] = $item;
        return $this;
    }
}
