<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Acquisition Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Acquisition
 * @subpackage Structs
 */
class Acquisition extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodeAcquisition;
    /**
     * The MontantLogement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MontantLogement;
    /**
     * The CodeTypeEtatBien
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodeTypeEtatBien;
    /**
     * The CodeTypeObjetAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodeTypeObjetAcquisition;
    /**
     * The MontantTerrain
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MontantTerrain;
    /**
     * The MontantFraisMutation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MontantFraisMutation;
    /**
     * The DatePrevisionnelle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatePrevisionnelle;
    /**
     * The CodeTypeClassificationBien
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodeTypeClassificationBien;
    /**
     * The MontantTravaux
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MontantTravaux;
    /**
     * The VilleAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $VilleAcquisition;
    /**
     * The SiretConstructeur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiretConstructeur;
    /**
     * The RaisonSocialeConstructeur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RaisonSocialeConstructeur;
    /**
     * The Ad1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ad1;
    /**
     * The Ad2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ad2;
    /**
     * The Surface
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Surface;
    /**
     * The EstBienPrisEnGarantie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EstBienPrisEnGarantie;
    /**
     * The CodeTypeCategorieAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeCategorieAcquisition;
    /**
     * The EstSIRETConnu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EstSIRETConnu;
    /**
     * The EstPourProduitHypoAcquiz
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EstPourProduitHypoAcquiz;
    /**
     * The MontantFraisAgence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MontantFraisAgence;
    /**
     * The MontantMeuble
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MontantMeuble;
    /**
     * The ImmatriculationDistributeurSupportsFinanciers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImmatriculationDistributeurSupportsFinanciers;
    /**
     * Constructor method for Acquisition
     * @uses Acquisition::setCodeAcquisition()
     * @uses Acquisition::setMontantLogement()
     * @uses Acquisition::setCodeTypeEtatBien()
     * @uses Acquisition::setCodeTypeObjetAcquisition()
     * @uses Acquisition::setMontantTerrain()
     * @uses Acquisition::setMontantFraisMutation()
     * @uses Acquisition::setDatePrevisionnelle()
     * @uses Acquisition::setCodeTypeClassificationBien()
     * @uses Acquisition::setMontantTravaux()
     * @uses Acquisition::setVilleAcquisition()
     * @uses Acquisition::setSiretConstructeur()
     * @uses Acquisition::setRaisonSocialeConstructeur()
     * @uses Acquisition::setAd1()
     * @uses Acquisition::setAd2()
     * @uses Acquisition::setSurface()
     * @uses Acquisition::setEstBienPrisEnGarantie()
     * @uses Acquisition::setCodeTypeCategorieAcquisition()
     * @uses Acquisition::setEstSIRETConnu()
     * @uses Acquisition::setEstPourProduitHypoAcquiz()
     * @uses Acquisition::setMontantFraisAgence()
     * @uses Acquisition::setMontantMeuble()
     * @uses Acquisition::setImmatriculationDistributeurSupportsFinanciers()
     * @param int $codeAcquisition
     * @param float $montantLogement
     * @param string $codeTypeEtatBien
     * @param string $codeTypeObjetAcquisition
     * @param float $montantTerrain
     * @param float $montantFraisMutation
     * @param string $datePrevisionnelle
     * @param string $codeTypeClassificationBien
     * @param float $montantTravaux
     * @param \CfcalSasieSDK\Entity\Ville $villeAcquisition
     * @param string $siretConstructeur
     * @param string $raisonSocialeConstructeur
     * @param string $ad1
     * @param string $ad2
     * @param float $surface
     * @param bool $estBienPrisEnGarantie
     * @param string $codeTypeCategorieAcquisition
     * @param bool $estSIRETConnu
     * @param bool $estPourProduitHypoAcquiz
     * @param float $montantFraisAgence
     * @param float $montantMeuble
     * @param string $immatriculationDistributeurSupportsFinanciers
     */
    public function __construct($codeAcquisition = null, $montantLogement = null, $codeTypeEtatBien = null, $codeTypeObjetAcquisition = null, $montantTerrain = null, $montantFraisMutation = null, $datePrevisionnelle = null, $codeTypeClassificationBien = null, $montantTravaux = null, \CfcalSasieSDK\Entity\Ville $villeAcquisition = null, $siretConstructeur = null, $raisonSocialeConstructeur = null, $ad1 = null, $ad2 = null, $surface = null, $estBienPrisEnGarantie = null, $codeTypeCategorieAcquisition = null, $estSIRETConnu = null, $estPourProduitHypoAcquiz = null, $montantFraisAgence = null, $montantMeuble = null, $immatriculationDistributeurSupportsFinanciers = null)
    {
        $this
            ->setCodeAcquisition($codeAcquisition)
            ->setMontantLogement($montantLogement)
            ->setCodeTypeEtatBien($codeTypeEtatBien)
            ->setCodeTypeObjetAcquisition($codeTypeObjetAcquisition)
            ->setMontantTerrain($montantTerrain)
            ->setMontantFraisMutation($montantFraisMutation)
            ->setDatePrevisionnelle($datePrevisionnelle)
            ->setCodeTypeClassificationBien($codeTypeClassificationBien)
            ->setMontantTravaux($montantTravaux)
            ->setVilleAcquisition($villeAcquisition)
            ->setSiretConstructeur($siretConstructeur)
            ->setRaisonSocialeConstructeur($raisonSocialeConstructeur)
            ->setAd1($ad1)
            ->setAd2($ad2)
            ->setSurface($surface)
            ->setEstBienPrisEnGarantie($estBienPrisEnGarantie)
            ->setCodeTypeCategorieAcquisition($codeTypeCategorieAcquisition)
            ->setEstSIRETConnu($estSIRETConnu)
            ->setEstPourProduitHypoAcquiz($estPourProduitHypoAcquiz)
            ->setMontantFraisAgence($montantFraisAgence)
            ->setMontantMeuble($montantMeuble)
            ->setImmatriculationDistributeurSupportsFinanciers($immatriculationDistributeurSupportsFinanciers);
    }
    /**
     * Get CodeAcquisition value
     * @return int|null
     */
    public function getCodeAcquisition()
    {
        return $this->CodeAcquisition;
    }
    /**
     * Set CodeAcquisition value
     * @param int $codeAcquisition
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setCodeAcquisition($codeAcquisition = null)
    {
        // validation for constraint: int
        if (!is_null($codeAcquisition) && !(is_int($codeAcquisition) || ctype_digit($codeAcquisition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeAcquisition, true), gettype($codeAcquisition)), __LINE__);
        }
        $this->CodeAcquisition = $codeAcquisition;
        return $this;
    }
    /**
     * Get MontantLogement value
     * @return float|null
     */
    public function getMontantLogement()
    {
        return $this->MontantLogement;
    }
    /**
     * Set MontantLogement value
     * @param float $montantLogement
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setMontantLogement($montantLogement = null)
    {
        // validation for constraint: float
        if (!is_null($montantLogement) && !(is_float($montantLogement) || is_numeric($montantLogement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantLogement, true), gettype($montantLogement)), __LINE__);
        }
        $this->MontantLogement = $montantLogement;
        return $this;
    }
    /**
     * Get CodeTypeEtatBien value
     * @return string|null
     */
    public function getCodeTypeEtatBien()
    {
        return $this->CodeTypeEtatBien;
    }
    /**
     * Set CodeTypeEtatBien value
     * @uses \CfcalSasieSDK\Enum\TypeEtatBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeEtatBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeEtatBien
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setCodeTypeEtatBien($codeTypeEtatBien = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeEtatBien::valueIsValid($codeTypeEtatBien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeEtatBien', is_array($codeTypeEtatBien) ? implode(', ', $codeTypeEtatBien) : var_export($codeTypeEtatBien, true), implode(', ', \CfcalSasieSDK\Enum\TypeEtatBien::getValidValues())), __LINE__);
        }
        $this->CodeTypeEtatBien = $codeTypeEtatBien;
        return $this;
    }
    /**
     * Get CodeTypeObjetAcquisition value
     * @return string|null
     */
    public function getCodeTypeObjetAcquisition()
    {
        return $this->CodeTypeObjetAcquisition;
    }
    /**
     * Set CodeTypeObjetAcquisition value
     * @uses \CfcalSasieSDK\Enum\TypeObjetAcquisition::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeObjetAcquisition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeObjetAcquisition
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setCodeTypeObjetAcquisition($codeTypeObjetAcquisition = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeObjetAcquisition::valueIsValid($codeTypeObjetAcquisition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeObjetAcquisition', is_array($codeTypeObjetAcquisition) ? implode(', ', $codeTypeObjetAcquisition) : var_export($codeTypeObjetAcquisition, true), implode(', ', \CfcalSasieSDK\Enum\TypeObjetAcquisition::getValidValues())), __LINE__);
        }
        $this->CodeTypeObjetAcquisition = $codeTypeObjetAcquisition;
        return $this;
    }
    /**
     * Get MontantTerrain value
     * @return float|null
     */
    public function getMontantTerrain()
    {
        return $this->MontantTerrain;
    }
    /**
     * Set MontantTerrain value
     * @param float $montantTerrain
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setMontantTerrain($montantTerrain = null)
    {
        // validation for constraint: float
        if (!is_null($montantTerrain) && !(is_float($montantTerrain) || is_numeric($montantTerrain))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantTerrain, true), gettype($montantTerrain)), __LINE__);
        }
        $this->MontantTerrain = $montantTerrain;
        return $this;
    }
    /**
     * Get MontantFraisMutation value
     * @return float|null
     */
    public function getMontantFraisMutation()
    {
        return $this->MontantFraisMutation;
    }
    /**
     * Set MontantFraisMutation value
     * @param float $montantFraisMutation
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setMontantFraisMutation($montantFraisMutation = null)
    {
        // validation for constraint: float
        if (!is_null($montantFraisMutation) && !(is_float($montantFraisMutation) || is_numeric($montantFraisMutation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantFraisMutation, true), gettype($montantFraisMutation)), __LINE__);
        }
        $this->MontantFraisMutation = $montantFraisMutation;
        return $this;
    }
    /**
     * Get DatePrevisionnelle value
     * @return string|null
     */
    public function getDatePrevisionnelle()
    {
        return $this->DatePrevisionnelle;
    }
    /**
     * Set DatePrevisionnelle value
     * @param string $datePrevisionnelle
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setDatePrevisionnelle($datePrevisionnelle = null)
    {
        // validation for constraint: string
        if (!is_null($datePrevisionnelle) && !is_string($datePrevisionnelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePrevisionnelle, true), gettype($datePrevisionnelle)), __LINE__);
        }
        $this->DatePrevisionnelle = $datePrevisionnelle;
        return $this;
    }
    /**
     * Get CodeTypeClassificationBien value
     * @return string|null
     */
    public function getCodeTypeClassificationBien()
    {
        return $this->CodeTypeClassificationBien;
    }
    /**
     * Set CodeTypeClassificationBien value
     * @uses \CfcalSasieSDK\Enum\TypeClassificationBien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeClassificationBien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeClassificationBien
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setCodeTypeClassificationBien($codeTypeClassificationBien = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeClassificationBien::valueIsValid($codeTypeClassificationBien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeClassificationBien', is_array($codeTypeClassificationBien) ? implode(', ', $codeTypeClassificationBien) : var_export($codeTypeClassificationBien, true), implode(', ', \CfcalSasieSDK\Enum\TypeClassificationBien::getValidValues())), __LINE__);
        }
        $this->CodeTypeClassificationBien = $codeTypeClassificationBien;
        return $this;
    }
    /**
     * Get MontantTravaux value
     * @return float|null
     */
    public function getMontantTravaux()
    {
        return $this->MontantTravaux;
    }
    /**
     * Set MontantTravaux value
     * @param float $montantTravaux
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setMontantTravaux($montantTravaux = null)
    {
        // validation for constraint: float
        if (!is_null($montantTravaux) && !(is_float($montantTravaux) || is_numeric($montantTravaux))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantTravaux, true), gettype($montantTravaux)), __LINE__);
        }
        $this->MontantTravaux = $montantTravaux;
        return $this;
    }
    /**
     * Get VilleAcquisition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVilleAcquisition()
    {
        return isset($this->VilleAcquisition) ? $this->VilleAcquisition : null;
    }
    /**
     * Set VilleAcquisition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Ville $villeAcquisition
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setVilleAcquisition(\CfcalSasieSDK\Entity\Ville $villeAcquisition = null)
    {
        if (is_null($villeAcquisition) || (is_array($villeAcquisition) && empty($villeAcquisition))) {
            unset($this->VilleAcquisition);
        } else {
            $this->VilleAcquisition = $villeAcquisition;
        }
        return $this;
    }
    /**
     * Get SiretConstructeur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiretConstructeur()
    {
        return isset($this->SiretConstructeur) ? $this->SiretConstructeur : null;
    }
    /**
     * Set SiretConstructeur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siretConstructeur
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setSiretConstructeur($siretConstructeur = null)
    {
        // validation for constraint: string
        if (!is_null($siretConstructeur) && !is_string($siretConstructeur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siretConstructeur, true), gettype($siretConstructeur)), __LINE__);
        }
        if (is_null($siretConstructeur) || (is_array($siretConstructeur) && empty($siretConstructeur))) {
            unset($this->SiretConstructeur);
        } else {
            $this->SiretConstructeur = $siretConstructeur;
        }
        return $this;
    }
    /**
     * Get RaisonSocialeConstructeur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRaisonSocialeConstructeur()
    {
        return isset($this->RaisonSocialeConstructeur) ? $this->RaisonSocialeConstructeur : null;
    }
    /**
     * Set RaisonSocialeConstructeur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $raisonSocialeConstructeur
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setRaisonSocialeConstructeur($raisonSocialeConstructeur = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSocialeConstructeur) && !is_string($raisonSocialeConstructeur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSocialeConstructeur, true), gettype($raisonSocialeConstructeur)), __LINE__);
        }
        if (is_null($raisonSocialeConstructeur) || (is_array($raisonSocialeConstructeur) && empty($raisonSocialeConstructeur))) {
            unset($this->RaisonSocialeConstructeur);
        } else {
            $this->RaisonSocialeConstructeur = $raisonSocialeConstructeur;
        }
        return $this;
    }
    /**
     * Get Ad1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd1()
    {
        return isset($this->Ad1) ? $this->Ad1 : null;
    }
    /**
     * Set Ad1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad1
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setAd1($ad1 = null)
    {
        // validation for constraint: string
        if (!is_null($ad1) && !is_string($ad1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad1, true), gettype($ad1)), __LINE__);
        }
        if (is_null($ad1) || (is_array($ad1) && empty($ad1))) {
            unset($this->Ad1);
        } else {
            $this->Ad1 = $ad1;
        }
        return $this;
    }
    /**
     * Get Ad2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2()
    {
        return isset($this->Ad2) ? $this->Ad2 : null;
    }
    /**
     * Set Ad2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setAd2($ad2 = null)
    {
        // validation for constraint: string
        if (!is_null($ad2) && !is_string($ad2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2, true), gettype($ad2)), __LINE__);
        }
        if (is_null($ad2) || (is_array($ad2) && empty($ad2))) {
            unset($this->Ad2);
        } else {
            $this->Ad2 = $ad2;
        }
        return $this;
    }
    /**
     * Get Surface value
     * @return float|null
     */
    public function getSurface()
    {
        return $this->Surface;
    }
    /**
     * Set Surface value
     * @param float $surface
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setSurface($surface = null)
    {
        // validation for constraint: float
        if (!is_null($surface) && !(is_float($surface) || is_numeric($surface))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surface, true), gettype($surface)), __LINE__);
        }
        $this->Surface = $surface;
        return $this;
    }
    /**
     * Get EstBienPrisEnGarantie value
     * @return bool|null
     */
    public function getEstBienPrisEnGarantie()
    {
        return $this->EstBienPrisEnGarantie;
    }
    /**
     * Set EstBienPrisEnGarantie value
     * @param bool $estBienPrisEnGarantie
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setEstBienPrisEnGarantie($estBienPrisEnGarantie = null)
    {
        // validation for constraint: boolean
        if (!is_null($estBienPrisEnGarantie) && !is_bool($estBienPrisEnGarantie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estBienPrisEnGarantie, true), gettype($estBienPrisEnGarantie)), __LINE__);
        }
        $this->EstBienPrisEnGarantie = $estBienPrisEnGarantie;
        return $this;
    }
    /**
     * Get CodeTypeCategorieAcquisition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeCategorieAcquisition()
    {
        return isset($this->CodeTypeCategorieAcquisition) ? $this->CodeTypeCategorieAcquisition : null;
    }
    /**
     * Set CodeTypeCategorieAcquisition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeCategorieAcquisition::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeCategorieAcquisition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeCategorieAcquisition
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setCodeTypeCategorieAcquisition($codeTypeCategorieAcquisition = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeCategorieAcquisition::valueIsValid($codeTypeCategorieAcquisition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeCategorieAcquisition', is_array($codeTypeCategorieAcquisition) ? implode(', ', $codeTypeCategorieAcquisition) : var_export($codeTypeCategorieAcquisition, true), implode(', ', \CfcalSasieSDK\Enum\TypeCategorieAcquisition::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeCategorieAcquisition) || (is_array($codeTypeCategorieAcquisition) && empty($codeTypeCategorieAcquisition))) {
            unset($this->CodeTypeCategorieAcquisition);
        } else {
            $this->CodeTypeCategorieAcquisition = $codeTypeCategorieAcquisition;
        }
        return $this;
    }
    /**
     * Get EstSIRETConnu value
     * @return bool|null
     */
    public function getEstSIRETConnu()
    {
        return $this->EstSIRETConnu;
    }
    /**
     * Set EstSIRETConnu value
     * @param bool $estSIRETConnu
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setEstSIRETConnu($estSIRETConnu = null)
    {
        // validation for constraint: boolean
        if (!is_null($estSIRETConnu) && !is_bool($estSIRETConnu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estSIRETConnu, true), gettype($estSIRETConnu)), __LINE__);
        }
        $this->EstSIRETConnu = $estSIRETConnu;
        return $this;
    }
    /**
     * Get EstPourProduitHypoAcquiz value
     * @return bool|null
     */
    public function getEstPourProduitHypoAcquiz()
    {
        return $this->EstPourProduitHypoAcquiz;
    }
    /**
     * Set EstPourProduitHypoAcquiz value
     * @param bool $estPourProduitHypoAcquiz
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setEstPourProduitHypoAcquiz($estPourProduitHypoAcquiz = null)
    {
        // validation for constraint: boolean
        if (!is_null($estPourProduitHypoAcquiz) && !is_bool($estPourProduitHypoAcquiz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estPourProduitHypoAcquiz, true), gettype($estPourProduitHypoAcquiz)), __LINE__);
        }
        $this->EstPourProduitHypoAcquiz = $estPourProduitHypoAcquiz;
        return $this;
    }
    /**
     * Get MontantFraisAgence value
     * @return float|null
     */
    public function getMontantFraisAgence()
    {
        return $this->MontantFraisAgence;
    }
    /**
     * Set MontantFraisAgence value
     * @param float $montantFraisAgence
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setMontantFraisAgence($montantFraisAgence = null)
    {
        // validation for constraint: float
        if (!is_null($montantFraisAgence) && !(is_float($montantFraisAgence) || is_numeric($montantFraisAgence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantFraisAgence, true), gettype($montantFraisAgence)), __LINE__);
        }
        $this->MontantFraisAgence = $montantFraisAgence;
        return $this;
    }
    /**
     * Get MontantMeuble value
     * @return float|null
     */
    public function getMontantMeuble()
    {
        return $this->MontantMeuble;
    }
    /**
     * Set MontantMeuble value
     * @param float $montantMeuble
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setMontantMeuble($montantMeuble = null)
    {
        // validation for constraint: float
        if (!is_null($montantMeuble) && !(is_float($montantMeuble) || is_numeric($montantMeuble))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantMeuble, true), gettype($montantMeuble)), __LINE__);
        }
        $this->MontantMeuble = $montantMeuble;
        return $this;
    }
    /**
     * Get ImmatriculationDistributeurSupportsFinanciers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImmatriculationDistributeurSupportsFinanciers()
    {
        return isset($this->ImmatriculationDistributeurSupportsFinanciers) ? $this->ImmatriculationDistributeurSupportsFinanciers : null;
    }
    /**
     * Set ImmatriculationDistributeurSupportsFinanciers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $immatriculationDistributeurSupportsFinanciers
     * @return \CfcalSasieSDK\Entity\Acquisition
     */
    public function setImmatriculationDistributeurSupportsFinanciers($immatriculationDistributeurSupportsFinanciers = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculationDistributeurSupportsFinanciers) && !is_string($immatriculationDistributeurSupportsFinanciers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculationDistributeurSupportsFinanciers, true), gettype($immatriculationDistributeurSupportsFinanciers)), __LINE__);
        }
        if (is_null($immatriculationDistributeurSupportsFinanciers) || (is_array($immatriculationDistributeurSupportsFinanciers) && empty($immatriculationDistributeurSupportsFinanciers))) {
            unset($this->ImmatriculationDistributeurSupportsFinanciers);
        } else {
            $this->ImmatriculationDistributeurSupportsFinanciers = $immatriculationDistributeurSupportsFinanciers;
        }
        return $this;
    }
}
