<?php

namespace CfcalSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultatOperationPublicBase Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultatOperationPublicBase
 * @subpackage Structs
 */
class ResultatOperationPublicBase extends ObjetPublicOutilsBase
{
    /**
     * The Statut
     * @var string
     */
    public $Statut;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSDK\Array\ArrayOfMessage
     */
    public $Messages;
    /**
     * Constructor method for ResultatOperationPublicBase
     * @uses ResultatOperationPublicBase::setStatut()
     * @uses ResultatOperationPublicBase::setMessages()
     * @param string $statut
     * @param \CfcalSDK\Array\ArrayOfMessage $messages
     */
    public function __construct($statut = null, \CfcalSDK\Array\ArrayOfMessage $messages = null)
    {
        $this
            ->setStatut($statut)
            ->setMessages($messages);
    }
    /**
     * Get Statut value
     * @return string|null
     */
    public function getStatut()
    {
        return $this->Statut;
    }
    /**
     * Set Statut value
     * @uses \CfcalSDK\Enum\StatutAppelWebservice::valueIsValid()
     * @uses \CfcalSDK\Enum\StatutAppelWebservice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statut
     * @return \CfcalSDK\Entity\ResultatOperationPublicBase
     */
    public function setStatut($statut = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSDK\Enum\StatutAppelWebservice::valueIsValid($statut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSDK\Enum\StatutAppelWebservice', is_array($statut) ? implode(', ', $statut) : var_export($statut, true), implode(', ', \CfcalSDK\Enum\StatutAppelWebservice::getValidValues())), __LINE__);
        }
        $this->Statut = $statut;
        return $this;
    }
    /**
     * Get Messages value
     * @return \CfcalSDK\Array\ArrayOfMessage|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \CfcalSDK\Array\ArrayOfMessage $messages
     * @return \CfcalSDK\Entity\ResultatOperationPublicBase
     */
    public function setMessages(\CfcalSDK\Array\ArrayOfMessage $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
}
