<?php

namespace CfcalSDK\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Renvoyer Service
 * @subpackage Services
 */
class Renvoyer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RenvoyerResultatConnexion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CfcalSDK\Entity\RenvoyerResultatConnexion $parameters
     * @return \CfcalSDK\Entity\RenvoyerResultatConnexionResponse|bool
     */
    public function RenvoyerResultatConnexion(\CfcalSDK\Entity\RenvoyerResultatConnexion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RenvoyerResultatConnexion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RenvoyerResultatConnexionEspaceSecurise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CfcalSDK\Entity\RenvoyerResultatConnexionEspaceSecurise $parameters
     * @return \CfcalSDK\Entity\RenvoyerResultatConnexionEspaceSecuriseResponse|bool
     */
    public function RenvoyerResultatConnexionEspaceSecurise(\CfcalSDK\Entity\RenvoyerResultatConnexionEspaceSecurise $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RenvoyerResultatConnexionEspaceSecurise($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CfcalSDK\Entity\RenvoyerResultatConnexionEspaceSecuriseResponse|\CfcalSDK\Entity\RenvoyerResultatConnexionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
