<?php

namespace CfcalSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultatConnexion Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultatConnexion
 * @subpackage Structs
 */
class ResultatConnexion extends ResultatAppelWebservice
{
    /**
     * The Jeton
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Jeton;
    /**
     * The DateExpirationJeton
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DateExpirationJeton;
    /**
     * Constructor method for ResultatConnexion
     * @uses ResultatConnexion::setJeton()
     * @uses ResultatConnexion::setDateExpirationJeton()
     * @param string $jeton
     * @param string $dateExpirationJeton
     */
    public function __construct($jeton = null, $dateExpirationJeton = null)
    {
        $this
            ->setJeton($jeton)
            ->setDateExpirationJeton($dateExpirationJeton);
    }
    /**
     * Get Jeton value
     * @return string|null
     */
    public function getJeton()
    {
        return $this->Jeton;
    }
    /**
     * Set Jeton value
     * @param string $jeton
     * @return \CfcalSDK\Entity\ResultatConnexion
     */
    public function setJeton($jeton = null)
    {
        // validation for constraint: string
        if (!is_null($jeton) && !is_string($jeton)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jeton, true), gettype($jeton)), __LINE__);
        }
        $this->Jeton = $jeton;
        return $this;
    }
    /**
     * Get DateExpirationJeton value
     * @return string|null
     */
    public function getDateExpirationJeton()
    {
        return $this->DateExpirationJeton;
    }
    /**
     * Set DateExpirationJeton value
     * @param string $dateExpirationJeton
     * @return \CfcalSDK\Entity\ResultatConnexion
     */
    public function setDateExpirationJeton($dateExpirationJeton = null)
    {
        // validation for constraint: string
        if (!is_null($dateExpirationJeton) && !is_string($dateExpirationJeton)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateExpirationJeton, true), gettype($dateExpirationJeton)), __LINE__);
        }
        $this->DateExpirationJeton = $dateExpirationJeton;
        return $this;
    }
}
