<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.cfcal-banque.fr/Homologation/services/Authentification/1.1/Service.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.cfcal-banque.fr/Homologation/services/Authentification/1.1/Service.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \CfcalSDK\ClassMap::get(),
);
/**
 * Samples for Renvoyer ServiceType
 */
$renvoyer = new \CfcalSDK\Service\Renvoyer($options);
/**
 * Sample call for RenvoyerResultatConnexion operation/method
 */
if ($renvoyer->RenvoyerResultatConnexion(new \CfcalSDK\Entity\RenvoyerResultatConnexion()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
/**
 * Sample call for RenvoyerResultatConnexionEspaceSecurise operation/method
 */
if ($renvoyer->RenvoyerResultatConnexionEspaceSecurise(new \CfcalSDK\Entity\RenvoyerResultatConnexionEspaceSecurise()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
