<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Renvoyer ServiceType
 * @subpackage Services
 */
class Renvoyer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RenvoyerResultatConnexion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RenvoyerResultatConnexion $parameters
     * @return \StructType\RenvoyerResultatConnexionResponse|bool
     */
    public function RenvoyerResultatConnexion(\StructType\RenvoyerResultatConnexion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RenvoyerResultatConnexion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RenvoyerResultatConnexionEspaceSecurise
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RenvoyerResultatConnexionEspaceSecurise $parameters
     * @return \StructType\RenvoyerResultatConnexionEspaceSecuriseResponse|bool
     */
    public function RenvoyerResultatConnexionEspaceSecurise(\StructType\RenvoyerResultatConnexionEspaceSecurise $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RenvoyerResultatConnexionEspaceSecurise($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RenvoyerResultatConnexionEspaceSecuriseResponse|\StructType\RenvoyerResultatConnexionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
