<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultatOperationPublicBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultatOperationPublicBase
 * @subpackage Structs
 */
class ResultatOperationPublicBase extends ObjetPublicOutilsBase
{
    /**
     * The Statut
     * @var string
     */
    public $Statut;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfMessage
     */
    public $Messages;
    /**
     * Constructor method for ResultatOperationPublicBase
     * @uses ResultatOperationPublicBase::setStatut()
     * @uses ResultatOperationPublicBase::setMessages()
     * @param string $statut
     * @param \ArrayType\ArrayOfMessage $messages
     */
    public function __construct($statut = null, \ArrayType\ArrayOfMessage $messages = null)
    {
        $this
            ->setStatut($statut)
            ->setMessages($messages);
    }
    /**
     * Get Statut value
     * @return string|null
     */
    public function getStatut()
    {
        return $this->Statut;
    }
    /**
     * Set Statut value
     * @uses \EnumType\StatutAppelWebservice::valueIsValid()
     * @uses \EnumType\StatutAppelWebservice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statut
     * @return \StructType\ResultatOperationPublicBase
     */
    public function setStatut($statut = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatutAppelWebservice::valueIsValid($statut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatutAppelWebservice', is_array($statut) ? implode(', ', $statut) : var_export($statut, true), implode(', ', \EnumType\StatutAppelWebservice::getValidValues())), __LINE__);
        }
        $this->Statut = $statut;
        return $this;
    }
    /**
     * Get Messages value
     * @return \ArrayType\ArrayOfMessage|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \ArrayType\ArrayOfMessage $messages
     * @return \StructType\ResultatOperationPublicBase
     */
    public function setMessages(\ArrayType\ArrayOfMessage $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
}
