<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTopicItemList StructType
 * @subpackage Structs
 */
class GetTopicItemList extends AbstractStructBase
{
    /**
     * The TopicID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TopicID;
    /**
     * The TypID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypID;
    /**
     * Constructor method for GetTopicItemList
     * @uses GetTopicItemList::setTopicID()
     * @uses GetTopicItemList::setTypID()
     * @param int $topicID
     * @param string $typID
     */
    public function __construct($topicID = null, $typID = null)
    {
        $this
            ->setTopicID($topicID)
            ->setTypID($typID);
    }
    /**
     * Get TopicID value
     * @return int
     */
    public function getTopicID()
    {
        return $this->TopicID;
    }
    /**
     * Set TopicID value
     * @param int $topicID
     * @return \StructType\GetTopicItemList
     */
    public function setTopicID($topicID = null)
    {
        // validation for constraint: int
        if (!is_null($topicID) && !(is_int($topicID) || ctype_digit($topicID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($topicID, true), gettype($topicID)), __LINE__);
        }
        $this->TopicID = $topicID;
        return $this;
    }
    /**
     * Get TypID value
     * @return string|null
     */
    public function getTypID()
    {
        return $this->TypID;
    }
    /**
     * Set TypID value
     * @param string $typID
     * @return \StructType\GetTopicItemList
     */
    public function setTypID($typID = null)
    {
        // validation for constraint: string
        if (!is_null($typID) && !is_string($typID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typID, true), gettype($typID)), __LINE__);
        }
        $this->TypID = $typID;
        return $this;
    }
}
