<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FullSearch StructType
 * @subpackage Structs
 */
class FullSearch extends AbstractStructBase
{
    /**
     * The bOnlyInNames
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bOnlyInNames;
    /**
     * The iWordSearchType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $iWordSearchType;
    /**
     * The bORSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bORSearch;
    /**
     * The sSearchString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sSearchString;
    /**
     * Constructor method for FullSearch
     * @uses FullSearch::setBOnlyInNames()
     * @uses FullSearch::setIWordSearchType()
     * @uses FullSearch::setBORSearch()
     * @uses FullSearch::setSSearchString()
     * @param bool $bOnlyInNames
     * @param int $iWordSearchType
     * @param bool $bORSearch
     * @param string $sSearchString
     */
    public function __construct($bOnlyInNames = null, $iWordSearchType = null, $bORSearch = null, $sSearchString = null)
    {
        $this
            ->setBOnlyInNames($bOnlyInNames)
            ->setIWordSearchType($iWordSearchType)
            ->setBORSearch($bORSearch)
            ->setSSearchString($sSearchString);
    }
    /**
     * Get bOnlyInNames value
     * @return bool
     */
    public function getBOnlyInNames()
    {
        return $this->bOnlyInNames;
    }
    /**
     * Set bOnlyInNames value
     * @param bool $bOnlyInNames
     * @return \StructType\FullSearch
     */
    public function setBOnlyInNames($bOnlyInNames = null)
    {
        // validation for constraint: boolean
        if (!is_null($bOnlyInNames) && !is_bool($bOnlyInNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bOnlyInNames, true), gettype($bOnlyInNames)), __LINE__);
        }
        $this->bOnlyInNames = $bOnlyInNames;
        return $this;
    }
    /**
     * Get iWordSearchType value
     * @return int
     */
    public function getIWordSearchType()
    {
        return $this->iWordSearchType;
    }
    /**
     * Set iWordSearchType value
     * @param int $iWordSearchType
     * @return \StructType\FullSearch
     */
    public function setIWordSearchType($iWordSearchType = null)
    {
        // validation for constraint: int
        if (!is_null($iWordSearchType) && !(is_int($iWordSearchType) || ctype_digit($iWordSearchType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iWordSearchType, true), gettype($iWordSearchType)), __LINE__);
        }
        $this->iWordSearchType = $iWordSearchType;
        return $this;
    }
    /**
     * Get bORSearch value
     * @return bool
     */
    public function getBORSearch()
    {
        return $this->bORSearch;
    }
    /**
     * Set bORSearch value
     * @param bool $bORSearch
     * @return \StructType\FullSearch
     */
    public function setBORSearch($bORSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($bORSearch) && !is_bool($bORSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bORSearch, true), gettype($bORSearch)), __LINE__);
        }
        $this->bORSearch = $bORSearch;
        return $this;
    }
    /**
     * Get sSearchString value
     * @return string|null
     */
    public function getSSearchString()
    {
        return $this->sSearchString;
    }
    /**
     * Set sSearchString value
     * @param string $sSearchString
     * @return \StructType\FullSearch
     */
    public function setSSearchString($sSearchString = null)
    {
        // validation for constraint: string
        if (!is_null($sSearchString) && !is_string($sSearchString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSearchString, true), gettype($sSearchString)), __LINE__);
        }
        $this->sSearchString = $sSearchString;
        return $this;
    }
}
