<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://mcsi.martens-software.de/common.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://mcsi.martens-software.de/common.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Hello ServiceType
 */
$hello = new \ServiceType\Hello($options);
/**
 * Sample call for HelloWorld operation/method
 */
if ($hello->HelloWorld(new \StructType\HelloWorld()) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Sample call for HelloSanaSoft operation/method
 */
if ($hello->HelloSanaSoft(new \StructType\HelloSanaSoft()) !== false) {
    print_r($hello->getResult());
} else {
    print_r($hello->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for GetItemList operation/method
 */
if ($get->GetItemList(new \StructType\GetItemList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemsCount operation/method
 */
if ($get->GetItemsCount(new \StructType\GetItemsCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTopicItemsCount operation/method
 */
if ($get->GetTopicItemsCount(new \StructType\GetTopicItemsCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFilteredItemList operation/method
 */
if ($get->GetFilteredItemList(new \StructType\GetFilteredItemList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContentPools operation/method
 */
if ($get->GetContentPools(new \StructType\GetContentPools()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemText operation/method
 */
if ($get->GetItemText(new \StructType\GetItemText()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTopicItemText operation/method
 */
if ($get->GetTopicItemText(new \StructType\GetTopicItemText()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemStruktur operation/method
 */
if ($get->GetItemStruktur(new \StructType\GetItemStruktur()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTopicItemStruktur operation/method
 */
if ($get->GetTopicItemStruktur(new \StructType\GetTopicItemStruktur()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetItemName operation/method
 */
if ($get->GetItemName(new \StructType\GetItemName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContentTopics operation/method
 */
if ($get->GetContentTopics(new \StructType\GetContentTopics()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTopicPools operation/method
 */
if ($get->GetTopicPools(new \StructType\GetTopicPools()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTopicName operation/method
 */
if ($get->GetTopicName(new \StructType\GetTopicName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTopicDescription operation/method
 */
if ($get->GetTopicDescription(new \StructType\GetTopicDescription()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTopicItemList operation/method
 */
if ($get->GetTopicItemList(new \StructType\GetTopicItemList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFilteredTopicItemList operation/method
 */
if ($get->GetFilteredTopicItemList(new \StructType\GetFilteredTopicItemList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCurrentItemText operation/method
 */
if ($get->GetCurrentItemText(new \StructType\GetCurrentItemText()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLinkText operation/method
 */
if ($get->GetLinkText(new \StructType\GetLinkText()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Topic ServiceType
 */
$topic = new \ServiceType\Topic($options);
$topic->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for TopicSearch operation/method
 */
if ($topic->TopicSearch(new \StructType\TopicSearch()) !== false) {
    print_r($topic->getResult());
} else {
    print_r($topic->getLastError());
}
/**
 * Samples for Pool ServiceType
 */
$pool = new \ServiceType\Pool($options);
$pool->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for PoolSearch operation/method
 */
if ($pool->PoolSearch(new \StructType\PoolSearch()) !== false) {
    print_r($pool->getResult());
} else {
    print_r($pool->getLastError());
}
/**
 * Samples for Full ServiceType
 */
$full = new \ServiceType\Full($options);
$full->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for FullSearch operation/method
 */
if ($full->FullSearch(new \StructType\FullSearch()) !== false) {
    print_r($full->getResult());
} else {
    print_r($full->getLastError());
}
