<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetItemText StructType
 * @subpackage Structs
 */
class GetItemText extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The BaustIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaustIDs;
    /**
     * Constructor method for GetItemText
     * @uses GetItemText::setItemID()
     * @uses GetItemText::setBaustIDs()
     * @param int $itemID
     * @param string $baustIDs
     */
    public function __construct($itemID = null, $baustIDs = null)
    {
        $this
            ->setItemID($itemID)
            ->setBaustIDs($baustIDs);
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\GetItemText
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get BaustIDs value
     * @return string|null
     */
    public function getBaustIDs()
    {
        return $this->BaustIDs;
    }
    /**
     * Set BaustIDs value
     * @param string $baustIDs
     * @return \StructType\GetItemText
     */
    public function setBaustIDs($baustIDs = null)
    {
        // validation for constraint: string
        if (!is_null($baustIDs) && !is_string($baustIDs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baustIDs, true), gettype($baustIDs)), __LINE__);
        }
        $this->BaustIDs = $baustIDs;
        return $this;
    }
}
