<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFilteredTopicItemList StructType
 * @subpackage Structs
 */
class GetFilteredTopicItemList extends AbstractStructBase
{
    /**
     * The TopicID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TopicID;
    /**
     * The TypID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypID;
    /**
     * The sFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sFilter;
    /**
     * Constructor method for GetFilteredTopicItemList
     * @uses GetFilteredTopicItemList::setTopicID()
     * @uses GetFilteredTopicItemList::setTypID()
     * @uses GetFilteredTopicItemList::setSFilter()
     * @param int $topicID
     * @param string $typID
     * @param string $sFilter
     */
    public function __construct($topicID = null, $typID = null, $sFilter = null)
    {
        $this
            ->setTopicID($topicID)
            ->setTypID($typID)
            ->setSFilter($sFilter);
    }
    /**
     * Get TopicID value
     * @return int
     */
    public function getTopicID()
    {
        return $this->TopicID;
    }
    /**
     * Set TopicID value
     * @param int $topicID
     * @return \StructType\GetFilteredTopicItemList
     */
    public function setTopicID($topicID = null)
    {
        // validation for constraint: int
        if (!is_null($topicID) && !(is_int($topicID) || ctype_digit($topicID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($topicID, true), gettype($topicID)), __LINE__);
        }
        $this->TopicID = $topicID;
        return $this;
    }
    /**
     * Get TypID value
     * @return string|null
     */
    public function getTypID()
    {
        return $this->TypID;
    }
    /**
     * Set TypID value
     * @param string $typID
     * @return \StructType\GetFilteredTopicItemList
     */
    public function setTypID($typID = null)
    {
        // validation for constraint: string
        if (!is_null($typID) && !is_string($typID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typID, true), gettype($typID)), __LINE__);
        }
        $this->TypID = $typID;
        return $this;
    }
    /**
     * Get sFilter value
     * @return string|null
     */
    public function getSFilter()
    {
        return $this->sFilter;
    }
    /**
     * Set sFilter value
     * @param string $sFilter
     * @return \StructType\GetFilteredTopicItemList
     */
    public function setSFilter($sFilter = null)
    {
        // validation for constraint: string
        if (!is_null($sFilter) && !is_string($sFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sFilter, true), gettype($sFilter)), __LINE__);
        }
        $this->sFilter = $sFilter;
        return $this;
    }
}
