<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTopicItemText StructType
 * @subpackage Structs
 */
class GetTopicItemText extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The TopicID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TopicID;
    /**
     * Constructor method for GetTopicItemText
     * @uses GetTopicItemText::setItemID()
     * @uses GetTopicItemText::setTopicID()
     * @param int $itemID
     * @param int $topicID
     */
    public function __construct($itemID = null, $topicID = null)
    {
        $this
            ->setItemID($itemID)
            ->setTopicID($topicID);
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\GetTopicItemText
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get TopicID value
     * @return int
     */
    public function getTopicID()
    {
        return $this->TopicID;
    }
    /**
     * Set TopicID value
     * @param int $topicID
     * @return \StructType\GetTopicItemText
     */
    public function setTopicID($topicID = null)
    {
        // validation for constraint: int
        if (!is_null($topicID) && !(is_int($topicID) || ctype_digit($topicID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($topicID, true), gettype($topicID)), __LINE__);
        }
        $this->TopicID = $topicID;
        return $this;
    }
}
