<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Topic ServiceType
 * @subpackage Services
 */
class Topic extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://martens-software.de/MCSI/Common', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named TopicSearch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Suche innerhalb eines freigeschalteten Thema. Beschreibung der Parameter: iTopicID: Thema ID; sSearchString: Such-String; bOnlyInNames: Wenn TRUE übergeben wird, findet die Suche nur in der Begriff-Bezeichnung statt. Sonst wird
     * sowohl in der Begriff-Bezeichnung als auch im Begriff-Text gesucht. iWordSearchType: Vergleich-Optionen. Erlaubte Werte: 0 = ganzes Wort muss vorkommen; 1 = Wortfragment muss übereinstimmen; 2 = Wortanfang muss übereinstimmen; 3 = Wortende muss
     * übereinstimmen. Hinweis: diese Optionen beziehen sich auf die Suche in der Begriff-Bezeichnung. Bei der Suche im Begriff-Text kann nur eine Wortfragment-Suche durchgeführt werden. bORSearch: Wenn TRUE übergeben wird: ODER Suche = mindestens eines
     * der Wörter muss vorkommen. Sonst wird eine UND Suche durchgeführt = alle Wörter müssen vorkommen.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TopicSearch $parameters
     * @return \StructType\TopicSearchResponse|bool
     */
    public function TopicSearch(\StructType\TopicSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TopicSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TopicSearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
