<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hello ServiceType
 * @subpackage Services
 */
class Hello extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HelloWorld
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HelloWorld $parameters
     * @return \StructType\HelloWorldResponse|bool
     */
    public function HelloWorld(\StructType\HelloWorld $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HelloWorld($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HelloSanaSoft
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HelloSanaSoft $parameters
     * @return \StructType\HelloSanaSoftResponse|bool
     */
    public function HelloSanaSoft(\StructType\HelloSanaSoft $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HelloSanaSoft($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HelloSanaSoftResponse|\StructType\HelloWorldResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
