<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://martens-software.de/MCSI/Common', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetItemList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert alle freigeschalteten Items für einen bestimmten Content-Pool. Kontaktieren Sie die SanaSoft-Hotline (0 94 92/94 20 30) für die Freischaltung weiterer Items!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemList $parameters
     * @return \StructType\GetItemListResponse|bool
     */
    public function GetItemList(\StructType\GetItemList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemsCount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Anzahl der freigeschalteten Items für einen bestimmten Content-Pool.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemsCount $parameters
     * @return \StructType\GetItemsCountResponse|bool
     */
    public function GetItemsCount(\StructType\GetItemsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopicItemsCount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Anzahl der freigeschalteten Items für ein bestimmtes Thema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopicItemsCount $parameters
     * @return \StructType\GetTopicItemsCountResponse|bool
     */
    public function GetTopicItemsCount(\StructType\GetTopicItemsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopicItemsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilteredItemList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert alle freigeschalteten Items (eines bestimmten Content-Pools) deren Anfangsbuchstaben mit dem in 'sFilter' übergebenen Buchstaben (Komma-getrennt) entspricht. Kontaktieren Sie die SanaSoft-Hotline (0 94 92/94 20 30) für die
     * Freischaltung weiterer Items!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilteredItemList $parameters
     * @return \StructType\GetFilteredItemListResponse|bool
     */
    public function GetFilteredItemList(\StructType\GetFilteredItemList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilteredItemList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContentPools
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Bezeichnung der freigeschalteten Content Pools. Kontaktieren Sie die SanaSoft-Hotline (0 94 92/94 20 30) für die Freischaltung weiterer Pools!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContentPools $parameters
     * @return \StructType\GetContentPoolsResponse|bool
     */
    public function GetContentPools(\StructType\GetContentPools $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetContentPools($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemText
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Texte zu einem Item. Wenn ein Bausteinfilter gewünscht ist, dann müssen die BausteinIDs in 'strBaustIDs' (Komma-getrennt) übergeben werden.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemText $parameters
     * @return \StructType\GetItemTextResponse|bool
     */
    public function GetItemText(\StructType\GetItemText $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopicItemText
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Texte zu einem Themen-Item.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopicItemText $parameters
     * @return \StructType\GetTopicItemTextResponse|bool
     */
    public function GetTopicItemText(\StructType\GetTopicItemText $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopicItemText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemStruktur
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Struktur der Text-Bausteine zu einem Item.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemStruktur $parameters
     * @return \StructType\GetItemStrukturResponse|bool
     */
    public function GetItemStruktur(\StructType\GetItemStruktur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemStruktur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopicItemStruktur
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Struktur der Text-Bausteine zu einem Themen-Item.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopicItemStruktur $parameters
     * @return \StructType\GetTopicItemStrukturResponse|bool
     */
    public function GetTopicItemStruktur(\StructType\GetTopicItemStruktur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopicItemStruktur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert den Namen eines Items.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemName $parameters
     * @return \StructType\GetItemNameResponse|bool
     */
    public function GetItemName(\StructType\GetItemName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContentTopics
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Bezeichnung der freigeschalteten Themen. Kontaktieren Sie die SanaSoft-Hotline (0 94 92/94 20 30) für die Freischaltung weiterer Themen!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContentTopics $parameters
     * @return \StructType\GetContentTopicsResponse|bool
     */
    public function GetContentTopics(\StructType\GetContentTopics $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetContentTopics($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopicPools
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Bezeichnung der freigeschalteten Content Pools zu einem Thema. Kontaktieren Sie die SanaSoft-Hotline (0 94 92/94 20 30) für die Freischaltung weiterer Themen!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopicPools $parameters
     * @return \StructType\GetTopicPoolsResponse|bool
     */
    public function GetTopicPools(\StructType\GetTopicPools $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopicPools($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopicName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Bezeichnung eines Thema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopicName $parameters
     * @return \StructType\GetTopicNameResponse|bool
     */
    public function GetTopicName(\StructType\GetTopicName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopicName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopicDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert die Beschreibung eines Thema. Kontaktieren Sie die SanaSoft-Hotline (0 94 92/94 20 30) für eine Änderung der Beschreibung!
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopicDescription $parameters
     * @return \StructType\GetTopicDescriptionResponse|bool
     */
    public function GetTopicDescription(\StructType\GetTopicDescription $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopicDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTopicItemList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert alle Items die zu einem Thema gehören.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTopicItemList $parameters
     * @return \StructType\GetTopicItemListResponse|bool
     */
    public function GetTopicItemList(\StructType\GetTopicItemList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTopicItemList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilteredTopicItemList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert alle Items die zu einem Thema gehören.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilteredTopicItemList $parameters
     * @return \StructType\GetFilteredTopicItemListResponse|bool
     */
    public function GetFilteredTopicItemList(\StructType\GetFilteredTopicItemList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilteredTopicItemList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentItemText
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert den aktuellen Text, bei terminbezogene Aktionen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrentItemText $parameters
     * @return \StructType\GetCurrentItemTextResponse|bool
     */
    public function GetCurrentItemText(\StructType\GetCurrentItemText $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrentItemText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLinkText
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://martens-software.de/MCSI/Common
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: Liefert den Text für einen verlinkten Begriff. Voraussetzung: der Begriff muss freigeschaltet sein (über einen Pool, Einzeltext, Thema oder wechselnden Content).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLinkText $parameters
     * @return \StructType\GetLinkTextResponse|bool
     */
    public function GetLinkText(\StructType\GetLinkText $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLinkText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetContentPoolsResponse|\StructType\GetContentTopicsResponse|\StructType\GetCurrentItemTextResponse|\StructType\GetFilteredItemListResponse|\StructType\GetFilteredTopicItemListResponse|\StructType\GetItemListResponse|\StructType\GetItemNameResponse|\StructType\GetItemsCountResponse|\StructType\GetItemStrukturResponse|\StructType\GetItemTextResponse|\StructType\GetLinkTextResponse|\StructType\GetTopicDescriptionResponse|\StructType\GetTopicItemListResponse|\StructType\GetTopicItemsCountResponse|\StructType\GetTopicItemStrukturResponse|\StructType\GetTopicItemTextResponse|\StructType\GetTopicNameResponse|\StructType\GetTopicPoolsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
