<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://energieausweis.dibt.de/published/WebServiceEnergieausweis/DibtEnergieAusweisServiceEx03.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://energieausweis.dibt.de/published/WebServiceEnergieausweis/DibtEnergieAusweisServiceEx03.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Datenregistratur ServiceType
 */
$datenregistratur = new \ServiceType\Datenregistratur($options);
/**
 * Sample call for Datenregistratur operation/method
 */
if ($datenregistratur->Datenregistratur(new \StructType\Datenregistratur()) !== false) {
    print_r($datenregistratur->getResult());
} else {
    print_r($datenregistratur->getLastError());
}
/**
 * Samples for Zusatzdaten ServiceType
 */
$zusatzdaten = new \ServiceType\Zusatzdaten($options);
/**
 * Sample call for ZusatzdatenErfassung operation/method
 */
if ($zusatzdaten->ZusatzdatenErfassung(new \StructType\ZusatzdatenErfassung()) !== false) {
    print_r($zusatzdaten->getResult());
} else {
    print_r($zusatzdaten->getLastError());
}
