<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentifizierung StructType
 * @subpackage Structs
 */
class Authentifizierung extends AbstractStructBase
{
    /**
     * The Aussteller_ID_DIBT
     * Meta information extracted from the WSDL
     * - documentation: Die bei der Registrierung am DIBt-Ausstellerportal verwendete Benutzer-ID des Benutzers der Organisation
     * @var string
     */
    public $Aussteller_ID_DIBT;
    /**
     * The Aussteller_PWD_DIBT
     * Meta information extracted from the WSDL
     * - documentation: Das beim DIBt-Ausstellerportal für den Benutzer hinterlegte Passwort – verschlüsselt nach MD5
     * @var string
     */
    public $Aussteller_PWD_DIBT;
    /**
     * Constructor method for Authentifizierung
     * @uses Authentifizierung::setAussteller_ID_DIBT()
     * @uses Authentifizierung::setAussteller_PWD_DIBT()
     * @param string $aussteller_ID_DIBT
     * @param string $aussteller_PWD_DIBT
     */
    public function __construct($aussteller_ID_DIBT = null, $aussteller_PWD_DIBT = null)
    {
        $this
            ->setAussteller_ID_DIBT($aussteller_ID_DIBT)
            ->setAussteller_PWD_DIBT($aussteller_PWD_DIBT);
    }
    /**
     * Get Aussteller_ID_DIBT value
     * @return string|null
     */
    public function getAussteller_ID_DIBT()
    {
        return $this->Aussteller_ID_DIBT;
    }
    /**
     * Set Aussteller_ID_DIBT value
     * @param string $aussteller_ID_DIBT
     * @return \StructType\Authentifizierung
     */
    public function setAussteller_ID_DIBT($aussteller_ID_DIBT = null)
    {
        // validation for constraint: string
        if (!is_null($aussteller_ID_DIBT) && !is_string($aussteller_ID_DIBT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aussteller_ID_DIBT, true), gettype($aussteller_ID_DIBT)), __LINE__);
        }
        $this->Aussteller_ID_DIBT = $aussteller_ID_DIBT;
        return $this;
    }
    /**
     * Get Aussteller_PWD_DIBT value
     * @return string|null
     */
    public function getAussteller_PWD_DIBT()
    {
        return $this->Aussteller_PWD_DIBT;
    }
    /**
     * Set Aussteller_PWD_DIBT value
     * @param string $aussteller_PWD_DIBT
     * @return \StructType\Authentifizierung
     */
    public function setAussteller_PWD_DIBT($aussteller_PWD_DIBT = null)
    {
        // validation for constraint: string
        if (!is_null($aussteller_PWD_DIBT) && !is_string($aussteller_PWD_DIBT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aussteller_PWD_DIBT, true), gettype($aussteller_PWD_DIBT)), __LINE__);
        }
        $this->Aussteller_PWD_DIBT = $aussteller_PWD_DIBT;
        return $this;
    }
}
