<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEB_Service_Antwort StructType
 * @subpackage Structs
 */
class WEB_Service_Antwort extends AbstractStructBase
{
    /**
     * The Rueckgabewert
     * @var \StructType\Rueckgabewert
     */
    public $Rueckgabewert;
    /**
     * The Registriernummer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Registriernummer;
    /**
     * The Restkontingent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Restkontingent;
    /**
     * The Datendatei
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Datendatei;
    /**
     * The Bemerkungen
     * Meta information extracted from the WSDL
     * - documentation: Feld ist bei Anforderung einer Datendatei befüllt mit einer Bemerkung mit bis zu 2000 Zeichen
     * - base: string
     * - maxLength: 2000
     * - minOccurs: 0
     * @var string
     */
    public $Bemerkungen;
    /**
     * Constructor method for WEB_Service_Antwort
     * @uses WEB_Service_Antwort::setRueckgabewert()
     * @uses WEB_Service_Antwort::setRegistriernummer()
     * @uses WEB_Service_Antwort::setRestkontingent()
     * @uses WEB_Service_Antwort::setDatendatei()
     * @uses WEB_Service_Antwort::setBemerkungen()
     * @param \StructType\Rueckgabewert $rueckgabewert
     * @param string $registriernummer
     * @param int $restkontingent
     * @param string $datendatei
     * @param string $bemerkungen
     */
    public function __construct(\StructType\Rueckgabewert $rueckgabewert = null, $registriernummer = null, $restkontingent = null, $datendatei = null, $bemerkungen = null)
    {
        $this
            ->setRueckgabewert($rueckgabewert)
            ->setRegistriernummer($registriernummer)
            ->setRestkontingent($restkontingent)
            ->setDatendatei($datendatei)
            ->setBemerkungen($bemerkungen);
    }
    /**
     * Get Rueckgabewert value
     * @return \StructType\Rueckgabewert|null
     */
    public function getRueckgabewert()
    {
        return $this->Rueckgabewert;
    }
    /**
     * Set Rueckgabewert value
     * @param \StructType\Rueckgabewert $rueckgabewert
     * @return \StructType\WEB_Service_Antwort
     */
    public function setRueckgabewert(\StructType\Rueckgabewert $rueckgabewert = null)
    {
        $this->Rueckgabewert = $rueckgabewert;
        return $this;
    }
    /**
     * Get Registriernummer value
     * @return string|null
     */
    public function getRegistriernummer()
    {
        return $this->Registriernummer;
    }
    /**
     * Set Registriernummer value
     * @param string $registriernummer
     * @return \StructType\WEB_Service_Antwort
     */
    public function setRegistriernummer($registriernummer = null)
    {
        // validation for constraint: string
        if (!is_null($registriernummer) && !is_string($registriernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registriernummer, true), gettype($registriernummer)), __LINE__);
        }
        $this->Registriernummer = $registriernummer;
        return $this;
    }
    /**
     * Get Restkontingent value
     * @return int|null
     */
    public function getRestkontingent()
    {
        return $this->Restkontingent;
    }
    /**
     * Set Restkontingent value
     * @param int $restkontingent
     * @return \StructType\WEB_Service_Antwort
     */
    public function setRestkontingent($restkontingent = null)
    {
        // validation for constraint: int
        if (!is_null($restkontingent) && !(is_int($restkontingent) || ctype_digit($restkontingent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($restkontingent, true), gettype($restkontingent)), __LINE__);
        }
        $this->Restkontingent = $restkontingent;
        return $this;
    }
    /**
     * Get Datendatei value
     * @return string|null
     */
    public function getDatendatei()
    {
        return $this->Datendatei;
    }
    /**
     * Set Datendatei value
     * @uses \EnumType\Datendatei::valueIsValid()
     * @uses \EnumType\Datendatei::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $datendatei
     * @return \StructType\WEB_Service_Antwort
     */
    public function setDatendatei($datendatei = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Datendatei::valueIsValid($datendatei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Datendatei', is_array($datendatei) ? implode(', ', $datendatei) : var_export($datendatei, true), implode(', ', \EnumType\Datendatei::getValidValues())), __LINE__);
        }
        $this->Datendatei = $datendatei;
        return $this;
    }
    /**
     * Get Bemerkungen value
     * @return string|null
     */
    public function getBemerkungen()
    {
        return $this->Bemerkungen;
    }
    /**
     * Set Bemerkungen value
     * @param string $bemerkungen
     * @return \StructType\WEB_Service_Antwort
     */
    public function setBemerkungen($bemerkungen = null)
    {
        // validation for constraint: string
        if (!is_null($bemerkungen) && !is_string($bemerkungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bemerkungen, true), gettype($bemerkungen)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($bemerkungen) && mb_strlen($bemerkungen) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($bemerkungen)), __LINE__);
        }
        $this->Bemerkungen = $bemerkungen;
        return $this;
    }
}
