<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsortiMiktar StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AsortiMiktar
 * @subpackage Structs
 */
class AsortiMiktar extends AbstractStructBase
{
    /**
     * The Adet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Adet;
    /**
     * The EkSecenekTanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EkSecenekTanim;
    /**
     * The GrupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GrupID;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * Constructor method for AsortiMiktar
     * @uses AsortiMiktar::setAdet()
     * @uses AsortiMiktar::setEkSecenekTanim()
     * @uses AsortiMiktar::setGrupID()
     * @uses AsortiMiktar::setID()
     * @param int $adet
     * @param string $ekSecenekTanim
     * @param int $grupID
     * @param int $iD
     */
    public function __construct($adet = null, $ekSecenekTanim = null, $grupID = null, $iD = null)
    {
        $this
            ->setAdet($adet)
            ->setEkSecenekTanim($ekSecenekTanim)
            ->setGrupID($grupID)
            ->setID($iD);
    }
    /**
     * Get Adet value
     * @return int|null
     */
    public function getAdet()
    {
        return $this->Adet;
    }
    /**
     * Set Adet value
     * @param int $adet
     * @return \StructType\AsortiMiktar
     */
    public function setAdet($adet = null)
    {
        // validation for constraint: int
        if (!is_null($adet) && !(is_int($adet) || ctype_digit($adet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adet, true), gettype($adet)), __LINE__);
        }
        $this->Adet = $adet;
        return $this;
    }
    /**
     * Get EkSecenekTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEkSecenekTanim()
    {
        return isset($this->EkSecenekTanim) ? $this->EkSecenekTanim : null;
    }
    /**
     * Set EkSecenekTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ekSecenekTanim
     * @return \StructType\AsortiMiktar
     */
    public function setEkSecenekTanim($ekSecenekTanim = null)
    {
        // validation for constraint: string
        if (!is_null($ekSecenekTanim) && !is_string($ekSecenekTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ekSecenekTanim, true), gettype($ekSecenekTanim)), __LINE__);
        }
        if (is_null($ekSecenekTanim) || (is_array($ekSecenekTanim) && empty($ekSecenekTanim))) {
            unset($this->EkSecenekTanim);
        } else {
            $this->EkSecenekTanim = $ekSecenekTanim;
        }
        return $this;
    }
    /**
     * Get GrupID value
     * @return int|null
     */
    public function getGrupID()
    {
        return $this->GrupID;
    }
    /**
     * Set GrupID value
     * @param int $grupID
     * @return \StructType\AsortiMiktar
     */
    public function setGrupID($grupID = null)
    {
        // validation for constraint: int
        if (!is_null($grupID) && !(is_int($grupID) || ctype_digit($grupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($grupID, true), gettype($grupID)), __LINE__);
        }
        $this->GrupID = $grupID;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\AsortiMiktar
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
}
