<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrunFiltre StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UrunFiltre
 * @subpackage Structs
 */
class UrunFiltre extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Aktif;
    /**
     * The Barkod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barkod;
    /**
     * The Dil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Dil;
    /**
     * The DuzenlemeTarihiBaslangic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DuzenlemeTarihiBaslangic;
    /**
     * The DuzenlemeTarihiBitis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DuzenlemeTarihiBitis;
    /**
     * The EklemeTarihiBaslangic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EklemeTarihiBaslangic;
    /**
     * The EklemeTarihiBitis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EklemeTarihiBitis;
    /**
     * The EntegrasyonDegerTanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntegrasyonDegerTanim;
    /**
     * The EntegrasyonKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntegrasyonKodu;
    /**
     * The Firsat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Firsat;
    /**
     * The FiyatFiltre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUrunFiyatFiltre
     */
    public $FiyatFiltre;
    /**
     * The IlgiliUrunleriListele
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IlgiliUrunleriListele;
    /**
     * The Indirimli
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Indirimli;
    /**
     * The KasaOnuFirsatlari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KasaOnuFirsatlari;
    /**
     * The KategoriID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KategoriID;
    /**
     * The KategoriIDList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $KategoriIDList;
    /**
     * The MarkaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MarkaID;
    /**
     * The MarketPlaceAktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MarketPlaceAktif;
    /**
     * The MarketPlaceAktif2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MarketPlaceAktif2;
    /**
     * The MarketPlaceAktif3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MarketPlaceAktif3;
    /**
     * The PasifResimleriGetir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PasifResimleriGetir;
    /**
     * The ResimDurumu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResimDurumu;
    /**
     * The ResimEklemeTarihiBaslangic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResimEklemeTarihiBaslangic;
    /**
     * The ResimEklemeTarihiBitis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResimEklemeTarihiBitis;
    /**
     * The StokGuncellemeTarihiBaslangic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StokGuncellemeTarihiBaslangic;
    /**
     * The StokGuncellemeTarihiBitis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StokGuncellemeTarihiBitis;
    /**
     * The StokKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StokKodu;
    /**
     * The StokKoduList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $StokKoduList;
    /**
     * The TedarikciID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TedarikciID;
    /**
     * The ToplamStokAdediBas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ToplamStokAdediBas;
    /**
     * The ToplamStokAdediSon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ToplamStokAdediSon;
    /**
     * The UrunKartiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * The Vitrin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Vitrin;
    /**
     * Constructor method for UrunFiltre
     * @uses UrunFiltre::setAktif()
     * @uses UrunFiltre::setBarkod()
     * @uses UrunFiltre::setDil()
     * @uses UrunFiltre::setDuzenlemeTarihiBaslangic()
     * @uses UrunFiltre::setDuzenlemeTarihiBitis()
     * @uses UrunFiltre::setEklemeTarihiBaslangic()
     * @uses UrunFiltre::setEklemeTarihiBitis()
     * @uses UrunFiltre::setEntegrasyonDegerTanim()
     * @uses UrunFiltre::setEntegrasyonKodu()
     * @uses UrunFiltre::setFirsat()
     * @uses UrunFiltre::setFiyatFiltre()
     * @uses UrunFiltre::setIlgiliUrunleriListele()
     * @uses UrunFiltre::setIndirimli()
     * @uses UrunFiltre::setKasaOnuFirsatlari()
     * @uses UrunFiltre::setKategoriID()
     * @uses UrunFiltre::setKategoriIDList()
     * @uses UrunFiltre::setMarkaID()
     * @uses UrunFiltre::setMarketPlaceAktif()
     * @uses UrunFiltre::setMarketPlaceAktif2()
     * @uses UrunFiltre::setMarketPlaceAktif3()
     * @uses UrunFiltre::setPasifResimleriGetir()
     * @uses UrunFiltre::setResimDurumu()
     * @uses UrunFiltre::setResimEklemeTarihiBaslangic()
     * @uses UrunFiltre::setResimEklemeTarihiBitis()
     * @uses UrunFiltre::setStokGuncellemeTarihiBaslangic()
     * @uses UrunFiltre::setStokGuncellemeTarihiBitis()
     * @uses UrunFiltre::setStokKodu()
     * @uses UrunFiltre::setStokKoduList()
     * @uses UrunFiltre::setTedarikciID()
     * @uses UrunFiltre::setToplamStokAdediBas()
     * @uses UrunFiltre::setToplamStokAdediSon()
     * @uses UrunFiltre::setUrunKartiID()
     * @uses UrunFiltre::setVitrin()
     * @param int $aktif
     * @param string $barkod
     * @param string $dil
     * @param string $duzenlemeTarihiBaslangic
     * @param string $duzenlemeTarihiBitis
     * @param string $eklemeTarihiBaslangic
     * @param string $eklemeTarihiBitis
     * @param string $entegrasyonDegerTanim
     * @param string $entegrasyonKodu
     * @param int $firsat
     * @param \ArrayType\ArrayOfUrunFiyatFiltre $fiyatFiltre
     * @param bool $ilgiliUrunleriListele
     * @param int $indirimli
     * @param int $kasaOnuFirsatlari
     * @param int $kategoriID
     * @param \ArrayType\ArrayOfint $kategoriIDList
     * @param int $markaID
     * @param bool $marketPlaceAktif
     * @param bool $marketPlaceAktif2
     * @param bool $marketPlaceAktif3
     * @param bool $pasifResimleriGetir
     * @param string $resimDurumu
     * @param string $resimEklemeTarihiBaslangic
     * @param string $resimEklemeTarihiBitis
     * @param string $stokGuncellemeTarihiBaslangic
     * @param string $stokGuncellemeTarihiBitis
     * @param string $stokKodu
     * @param \ArrayType\ArrayOfstring $stokKoduList
     * @param int $tedarikciID
     * @param float $toplamStokAdediBas
     * @param float $toplamStokAdediSon
     * @param int $urunKartiID
     * @param int $vitrin
     */
    public function __construct($aktif = null, $barkod = null, $dil = null, $duzenlemeTarihiBaslangic = null, $duzenlemeTarihiBitis = null, $eklemeTarihiBaslangic = null, $eklemeTarihiBitis = null, $entegrasyonDegerTanim = null, $entegrasyonKodu = null, $firsat = null, \ArrayType\ArrayOfUrunFiyatFiltre $fiyatFiltre = null, $ilgiliUrunleriListele = null, $indirimli = null, $kasaOnuFirsatlari = null, $kategoriID = null, \ArrayType\ArrayOfint $kategoriIDList = null, $markaID = null, $marketPlaceAktif = null, $marketPlaceAktif2 = null, $marketPlaceAktif3 = null, $pasifResimleriGetir = null, $resimDurumu = null, $resimEklemeTarihiBaslangic = null, $resimEklemeTarihiBitis = null, $stokGuncellemeTarihiBaslangic = null, $stokGuncellemeTarihiBitis = null, $stokKodu = null, \ArrayType\ArrayOfstring $stokKoduList = null, $tedarikciID = null, $toplamStokAdediBas = null, $toplamStokAdediSon = null, $urunKartiID = null, $vitrin = null)
    {
        $this
            ->setAktif($aktif)
            ->setBarkod($barkod)
            ->setDil($dil)
            ->setDuzenlemeTarihiBaslangic($duzenlemeTarihiBaslangic)
            ->setDuzenlemeTarihiBitis($duzenlemeTarihiBitis)
            ->setEklemeTarihiBaslangic($eklemeTarihiBaslangic)
            ->setEklemeTarihiBitis($eklemeTarihiBitis)
            ->setEntegrasyonDegerTanim($entegrasyonDegerTanim)
            ->setEntegrasyonKodu($entegrasyonKodu)
            ->setFirsat($firsat)
            ->setFiyatFiltre($fiyatFiltre)
            ->setIlgiliUrunleriListele($ilgiliUrunleriListele)
            ->setIndirimli($indirimli)
            ->setKasaOnuFirsatlari($kasaOnuFirsatlari)
            ->setKategoriID($kategoriID)
            ->setKategoriIDList($kategoriIDList)
            ->setMarkaID($markaID)
            ->setMarketPlaceAktif($marketPlaceAktif)
            ->setMarketPlaceAktif2($marketPlaceAktif2)
            ->setMarketPlaceAktif3($marketPlaceAktif3)
            ->setPasifResimleriGetir($pasifResimleriGetir)
            ->setResimDurumu($resimDurumu)
            ->setResimEklemeTarihiBaslangic($resimEklemeTarihiBaslangic)
            ->setResimEklemeTarihiBitis($resimEklemeTarihiBitis)
            ->setStokGuncellemeTarihiBaslangic($stokGuncellemeTarihiBaslangic)
            ->setStokGuncellemeTarihiBitis($stokGuncellemeTarihiBitis)
            ->setStokKodu($stokKodu)
            ->setStokKoduList($stokKoduList)
            ->setTedarikciID($tedarikciID)
            ->setToplamStokAdediBas($toplamStokAdediBas)
            ->setToplamStokAdediSon($toplamStokAdediSon)
            ->setUrunKartiID($urunKartiID)
            ->setVitrin($vitrin);
    }
    /**
     * Get Aktif value
     * @return int|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param int $aktif
     * @return \StructType\UrunFiltre
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: int
        if (!is_null($aktif) && !(is_int($aktif) || ctype_digit($aktif))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get Barkod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarkod()
    {
        return isset($this->Barkod) ? $this->Barkod : null;
    }
    /**
     * Set Barkod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barkod
     * @return \StructType\UrunFiltre
     */
    public function setBarkod($barkod = null)
    {
        // validation for constraint: string
        if (!is_null($barkod) && !is_string($barkod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barkod, true), gettype($barkod)), __LINE__);
        }
        if (is_null($barkod) || (is_array($barkod) && empty($barkod))) {
            unset($this->Barkod);
        } else {
            $this->Barkod = $barkod;
        }
        return $this;
    }
    /**
     * Get Dil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDil()
    {
        return isset($this->Dil) ? $this->Dil : null;
    }
    /**
     * Set Dil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dil
     * @return \StructType\UrunFiltre
     */
    public function setDil($dil = null)
    {
        // validation for constraint: string
        if (!is_null($dil) && !is_string($dil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dil, true), gettype($dil)), __LINE__);
        }
        if (is_null($dil) || (is_array($dil) && empty($dil))) {
            unset($this->Dil);
        } else {
            $this->Dil = $dil;
        }
        return $this;
    }
    /**
     * Get DuzenlemeTarihiBaslangic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDuzenlemeTarihiBaslangic()
    {
        return isset($this->DuzenlemeTarihiBaslangic) ? $this->DuzenlemeTarihiBaslangic : null;
    }
    /**
     * Set DuzenlemeTarihiBaslangic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $duzenlemeTarihiBaslangic
     * @return \StructType\UrunFiltre
     */
    public function setDuzenlemeTarihiBaslangic($duzenlemeTarihiBaslangic = null)
    {
        // validation for constraint: string
        if (!is_null($duzenlemeTarihiBaslangic) && !is_string($duzenlemeTarihiBaslangic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duzenlemeTarihiBaslangic, true), gettype($duzenlemeTarihiBaslangic)), __LINE__);
        }
        if (is_null($duzenlemeTarihiBaslangic) || (is_array($duzenlemeTarihiBaslangic) && empty($duzenlemeTarihiBaslangic))) {
            unset($this->DuzenlemeTarihiBaslangic);
        } else {
            $this->DuzenlemeTarihiBaslangic = $duzenlemeTarihiBaslangic;
        }
        return $this;
    }
    /**
     * Get DuzenlemeTarihiBitis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDuzenlemeTarihiBitis()
    {
        return isset($this->DuzenlemeTarihiBitis) ? $this->DuzenlemeTarihiBitis : null;
    }
    /**
     * Set DuzenlemeTarihiBitis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $duzenlemeTarihiBitis
     * @return \StructType\UrunFiltre
     */
    public function setDuzenlemeTarihiBitis($duzenlemeTarihiBitis = null)
    {
        // validation for constraint: string
        if (!is_null($duzenlemeTarihiBitis) && !is_string($duzenlemeTarihiBitis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duzenlemeTarihiBitis, true), gettype($duzenlemeTarihiBitis)), __LINE__);
        }
        if (is_null($duzenlemeTarihiBitis) || (is_array($duzenlemeTarihiBitis) && empty($duzenlemeTarihiBitis))) {
            unset($this->DuzenlemeTarihiBitis);
        } else {
            $this->DuzenlemeTarihiBitis = $duzenlemeTarihiBitis;
        }
        return $this;
    }
    /**
     * Get EklemeTarihiBaslangic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEklemeTarihiBaslangic()
    {
        return isset($this->EklemeTarihiBaslangic) ? $this->EklemeTarihiBaslangic : null;
    }
    /**
     * Set EklemeTarihiBaslangic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eklemeTarihiBaslangic
     * @return \StructType\UrunFiltre
     */
    public function setEklemeTarihiBaslangic($eklemeTarihiBaslangic = null)
    {
        // validation for constraint: string
        if (!is_null($eklemeTarihiBaslangic) && !is_string($eklemeTarihiBaslangic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklemeTarihiBaslangic, true), gettype($eklemeTarihiBaslangic)), __LINE__);
        }
        if (is_null($eklemeTarihiBaslangic) || (is_array($eklemeTarihiBaslangic) && empty($eklemeTarihiBaslangic))) {
            unset($this->EklemeTarihiBaslangic);
        } else {
            $this->EklemeTarihiBaslangic = $eklemeTarihiBaslangic;
        }
        return $this;
    }
    /**
     * Get EklemeTarihiBitis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEklemeTarihiBitis()
    {
        return isset($this->EklemeTarihiBitis) ? $this->EklemeTarihiBitis : null;
    }
    /**
     * Set EklemeTarihiBitis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eklemeTarihiBitis
     * @return \StructType\UrunFiltre
     */
    public function setEklemeTarihiBitis($eklemeTarihiBitis = null)
    {
        // validation for constraint: string
        if (!is_null($eklemeTarihiBitis) && !is_string($eklemeTarihiBitis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklemeTarihiBitis, true), gettype($eklemeTarihiBitis)), __LINE__);
        }
        if (is_null($eklemeTarihiBitis) || (is_array($eklemeTarihiBitis) && empty($eklemeTarihiBitis))) {
            unset($this->EklemeTarihiBitis);
        } else {
            $this->EklemeTarihiBitis = $eklemeTarihiBitis;
        }
        return $this;
    }
    /**
     * Get EntegrasyonDegerTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntegrasyonDegerTanim()
    {
        return isset($this->EntegrasyonDegerTanim) ? $this->EntegrasyonDegerTanim : null;
    }
    /**
     * Set EntegrasyonDegerTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entegrasyonDegerTanim
     * @return \StructType\UrunFiltre
     */
    public function setEntegrasyonDegerTanim($entegrasyonDegerTanim = null)
    {
        // validation for constraint: string
        if (!is_null($entegrasyonDegerTanim) && !is_string($entegrasyonDegerTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entegrasyonDegerTanim, true), gettype($entegrasyonDegerTanim)), __LINE__);
        }
        if (is_null($entegrasyonDegerTanim) || (is_array($entegrasyonDegerTanim) && empty($entegrasyonDegerTanim))) {
            unset($this->EntegrasyonDegerTanim);
        } else {
            $this->EntegrasyonDegerTanim = $entegrasyonDegerTanim;
        }
        return $this;
    }
    /**
     * Get EntegrasyonKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntegrasyonKodu()
    {
        return isset($this->EntegrasyonKodu) ? $this->EntegrasyonKodu : null;
    }
    /**
     * Set EntegrasyonKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entegrasyonKodu
     * @return \StructType\UrunFiltre
     */
    public function setEntegrasyonKodu($entegrasyonKodu = null)
    {
        // validation for constraint: string
        if (!is_null($entegrasyonKodu) && !is_string($entegrasyonKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entegrasyonKodu, true), gettype($entegrasyonKodu)), __LINE__);
        }
        if (is_null($entegrasyonKodu) || (is_array($entegrasyonKodu) && empty($entegrasyonKodu))) {
            unset($this->EntegrasyonKodu);
        } else {
            $this->EntegrasyonKodu = $entegrasyonKodu;
        }
        return $this;
    }
    /**
     * Get Firsat value
     * @return int|null
     */
    public function getFirsat()
    {
        return $this->Firsat;
    }
    /**
     * Set Firsat value
     * @param int $firsat
     * @return \StructType\UrunFiltre
     */
    public function setFirsat($firsat = null)
    {
        // validation for constraint: int
        if (!is_null($firsat) && !(is_int($firsat) || ctype_digit($firsat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firsat, true), gettype($firsat)), __LINE__);
        }
        $this->Firsat = $firsat;
        return $this;
    }
    /**
     * Get FiyatFiltre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUrunFiyatFiltre|null
     */
    public function getFiyatFiltre()
    {
        return isset($this->FiyatFiltre) ? $this->FiyatFiltre : null;
    }
    /**
     * Set FiyatFiltre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUrunFiyatFiltre $fiyatFiltre
     * @return \StructType\UrunFiltre
     */
    public function setFiyatFiltre(\ArrayType\ArrayOfUrunFiyatFiltre $fiyatFiltre = null)
    {
        if (is_null($fiyatFiltre) || (is_array($fiyatFiltre) && empty($fiyatFiltre))) {
            unset($this->FiyatFiltre);
        } else {
            $this->FiyatFiltre = $fiyatFiltre;
        }
        return $this;
    }
    /**
     * Get IlgiliUrunleriListele value
     * @return bool|null
     */
    public function getIlgiliUrunleriListele()
    {
        return $this->IlgiliUrunleriListele;
    }
    /**
     * Set IlgiliUrunleriListele value
     * @param bool $ilgiliUrunleriListele
     * @return \StructType\UrunFiltre
     */
    public function setIlgiliUrunleriListele($ilgiliUrunleriListele = null)
    {
        // validation for constraint: boolean
        if (!is_null($ilgiliUrunleriListele) && !is_bool($ilgiliUrunleriListele)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ilgiliUrunleriListele, true), gettype($ilgiliUrunleriListele)), __LINE__);
        }
        $this->IlgiliUrunleriListele = $ilgiliUrunleriListele;
        return $this;
    }
    /**
     * Get Indirimli value
     * @return int|null
     */
    public function getIndirimli()
    {
        return $this->Indirimli;
    }
    /**
     * Set Indirimli value
     * @param int $indirimli
     * @return \StructType\UrunFiltre
     */
    public function setIndirimli($indirimli = null)
    {
        // validation for constraint: int
        if (!is_null($indirimli) && !(is_int($indirimli) || ctype_digit($indirimli))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indirimli, true), gettype($indirimli)), __LINE__);
        }
        $this->Indirimli = $indirimli;
        return $this;
    }
    /**
     * Get KasaOnuFirsatlari value
     * @return int|null
     */
    public function getKasaOnuFirsatlari()
    {
        return $this->KasaOnuFirsatlari;
    }
    /**
     * Set KasaOnuFirsatlari value
     * @param int $kasaOnuFirsatlari
     * @return \StructType\UrunFiltre
     */
    public function setKasaOnuFirsatlari($kasaOnuFirsatlari = null)
    {
        // validation for constraint: int
        if (!is_null($kasaOnuFirsatlari) && !(is_int($kasaOnuFirsatlari) || ctype_digit($kasaOnuFirsatlari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kasaOnuFirsatlari, true), gettype($kasaOnuFirsatlari)), __LINE__);
        }
        $this->KasaOnuFirsatlari = $kasaOnuFirsatlari;
        return $this;
    }
    /**
     * Get KategoriID value
     * @return int|null
     */
    public function getKategoriID()
    {
        return $this->KategoriID;
    }
    /**
     * Set KategoriID value
     * @param int $kategoriID
     * @return \StructType\UrunFiltre
     */
    public function setKategoriID($kategoriID = null)
    {
        // validation for constraint: int
        if (!is_null($kategoriID) && !(is_int($kategoriID) || ctype_digit($kategoriID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategoriID, true), gettype($kategoriID)), __LINE__);
        }
        $this->KategoriID = $kategoriID;
        return $this;
    }
    /**
     * Get KategoriIDList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getKategoriIDList()
    {
        return isset($this->KategoriIDList) ? $this->KategoriIDList : null;
    }
    /**
     * Set KategoriIDList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $kategoriIDList
     * @return \StructType\UrunFiltre
     */
    public function setKategoriIDList(\ArrayType\ArrayOfint $kategoriIDList = null)
    {
        if (is_null($kategoriIDList) || (is_array($kategoriIDList) && empty($kategoriIDList))) {
            unset($this->KategoriIDList);
        } else {
            $this->KategoriIDList = $kategoriIDList;
        }
        return $this;
    }
    /**
     * Get MarkaID value
     * @return int|null
     */
    public function getMarkaID()
    {
        return $this->MarkaID;
    }
    /**
     * Set MarkaID value
     * @param int $markaID
     * @return \StructType\UrunFiltre
     */
    public function setMarkaID($markaID = null)
    {
        // validation for constraint: int
        if (!is_null($markaID) && !(is_int($markaID) || ctype_digit($markaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($markaID, true), gettype($markaID)), __LINE__);
        }
        $this->MarkaID = $markaID;
        return $this;
    }
    /**
     * Get MarketPlaceAktif value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMarketPlaceAktif()
    {
        return isset($this->MarketPlaceAktif) ? $this->MarketPlaceAktif : null;
    }
    /**
     * Set MarketPlaceAktif value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $marketPlaceAktif
     * @return \StructType\UrunFiltre
     */
    public function setMarketPlaceAktif($marketPlaceAktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketPlaceAktif) && !is_bool($marketPlaceAktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marketPlaceAktif, true), gettype($marketPlaceAktif)), __LINE__);
        }
        if (is_null($marketPlaceAktif) || (is_array($marketPlaceAktif) && empty($marketPlaceAktif))) {
            unset($this->MarketPlaceAktif);
        } else {
            $this->MarketPlaceAktif = $marketPlaceAktif;
        }
        return $this;
    }
    /**
     * Get MarketPlaceAktif2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMarketPlaceAktif2()
    {
        return isset($this->MarketPlaceAktif2) ? $this->MarketPlaceAktif2 : null;
    }
    /**
     * Set MarketPlaceAktif2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $marketPlaceAktif2
     * @return \StructType\UrunFiltre
     */
    public function setMarketPlaceAktif2($marketPlaceAktif2 = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketPlaceAktif2) && !is_bool($marketPlaceAktif2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marketPlaceAktif2, true), gettype($marketPlaceAktif2)), __LINE__);
        }
        if (is_null($marketPlaceAktif2) || (is_array($marketPlaceAktif2) && empty($marketPlaceAktif2))) {
            unset($this->MarketPlaceAktif2);
        } else {
            $this->MarketPlaceAktif2 = $marketPlaceAktif2;
        }
        return $this;
    }
    /**
     * Get MarketPlaceAktif3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMarketPlaceAktif3()
    {
        return isset($this->MarketPlaceAktif3) ? $this->MarketPlaceAktif3 : null;
    }
    /**
     * Set MarketPlaceAktif3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $marketPlaceAktif3
     * @return \StructType\UrunFiltre
     */
    public function setMarketPlaceAktif3($marketPlaceAktif3 = null)
    {
        // validation for constraint: boolean
        if (!is_null($marketPlaceAktif3) && !is_bool($marketPlaceAktif3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($marketPlaceAktif3, true), gettype($marketPlaceAktif3)), __LINE__);
        }
        if (is_null($marketPlaceAktif3) || (is_array($marketPlaceAktif3) && empty($marketPlaceAktif3))) {
            unset($this->MarketPlaceAktif3);
        } else {
            $this->MarketPlaceAktif3 = $marketPlaceAktif3;
        }
        return $this;
    }
    /**
     * Get PasifResimleriGetir value
     * @return bool|null
     */
    public function getPasifResimleriGetir()
    {
        return $this->PasifResimleriGetir;
    }
    /**
     * Set PasifResimleriGetir value
     * @param bool $pasifResimleriGetir
     * @return \StructType\UrunFiltre
     */
    public function setPasifResimleriGetir($pasifResimleriGetir = null)
    {
        // validation for constraint: boolean
        if (!is_null($pasifResimleriGetir) && !is_bool($pasifResimleriGetir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pasifResimleriGetir, true), gettype($pasifResimleriGetir)), __LINE__);
        }
        $this->PasifResimleriGetir = $pasifResimleriGetir;
        return $this;
    }
    /**
     * Get ResimDurumu value
     * @return string|null
     */
    public function getResimDurumu()
    {
        return $this->ResimDurumu;
    }
    /**
     * Set ResimDurumu value
     * @uses \EnumType\UrunResimDurumu::valueIsValid()
     * @uses \EnumType\UrunResimDurumu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resimDurumu
     * @return \StructType\UrunFiltre
     */
    public function setResimDurumu($resimDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UrunResimDurumu::valueIsValid($resimDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UrunResimDurumu', is_array($resimDurumu) ? implode(', ', $resimDurumu) : var_export($resimDurumu, true), implode(', ', \EnumType\UrunResimDurumu::getValidValues())), __LINE__);
        }
        $this->ResimDurumu = $resimDurumu;
        return $this;
    }
    /**
     * Get ResimEklemeTarihiBaslangic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResimEklemeTarihiBaslangic()
    {
        return isset($this->ResimEklemeTarihiBaslangic) ? $this->ResimEklemeTarihiBaslangic : null;
    }
    /**
     * Set ResimEklemeTarihiBaslangic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resimEklemeTarihiBaslangic
     * @return \StructType\UrunFiltre
     */
    public function setResimEklemeTarihiBaslangic($resimEklemeTarihiBaslangic = null)
    {
        // validation for constraint: string
        if (!is_null($resimEklemeTarihiBaslangic) && !is_string($resimEklemeTarihiBaslangic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resimEklemeTarihiBaslangic, true), gettype($resimEklemeTarihiBaslangic)), __LINE__);
        }
        if (is_null($resimEklemeTarihiBaslangic) || (is_array($resimEklemeTarihiBaslangic) && empty($resimEklemeTarihiBaslangic))) {
            unset($this->ResimEklemeTarihiBaslangic);
        } else {
            $this->ResimEklemeTarihiBaslangic = $resimEklemeTarihiBaslangic;
        }
        return $this;
    }
    /**
     * Get ResimEklemeTarihiBitis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResimEklemeTarihiBitis()
    {
        return isset($this->ResimEklemeTarihiBitis) ? $this->ResimEklemeTarihiBitis : null;
    }
    /**
     * Set ResimEklemeTarihiBitis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resimEklemeTarihiBitis
     * @return \StructType\UrunFiltre
     */
    public function setResimEklemeTarihiBitis($resimEklemeTarihiBitis = null)
    {
        // validation for constraint: string
        if (!is_null($resimEklemeTarihiBitis) && !is_string($resimEklemeTarihiBitis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resimEklemeTarihiBitis, true), gettype($resimEklemeTarihiBitis)), __LINE__);
        }
        if (is_null($resimEklemeTarihiBitis) || (is_array($resimEklemeTarihiBitis) && empty($resimEklemeTarihiBitis))) {
            unset($this->ResimEklemeTarihiBitis);
        } else {
            $this->ResimEklemeTarihiBitis = $resimEklemeTarihiBitis;
        }
        return $this;
    }
    /**
     * Get StokGuncellemeTarihiBaslangic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStokGuncellemeTarihiBaslangic()
    {
        return isset($this->StokGuncellemeTarihiBaslangic) ? $this->StokGuncellemeTarihiBaslangic : null;
    }
    /**
     * Set StokGuncellemeTarihiBaslangic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stokGuncellemeTarihiBaslangic
     * @return \StructType\UrunFiltre
     */
    public function setStokGuncellemeTarihiBaslangic($stokGuncellemeTarihiBaslangic = null)
    {
        // validation for constraint: string
        if (!is_null($stokGuncellemeTarihiBaslangic) && !is_string($stokGuncellemeTarihiBaslangic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stokGuncellemeTarihiBaslangic, true), gettype($stokGuncellemeTarihiBaslangic)), __LINE__);
        }
        if (is_null($stokGuncellemeTarihiBaslangic) || (is_array($stokGuncellemeTarihiBaslangic) && empty($stokGuncellemeTarihiBaslangic))) {
            unset($this->StokGuncellemeTarihiBaslangic);
        } else {
            $this->StokGuncellemeTarihiBaslangic = $stokGuncellemeTarihiBaslangic;
        }
        return $this;
    }
    /**
     * Get StokGuncellemeTarihiBitis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStokGuncellemeTarihiBitis()
    {
        return isset($this->StokGuncellemeTarihiBitis) ? $this->StokGuncellemeTarihiBitis : null;
    }
    /**
     * Set StokGuncellemeTarihiBitis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stokGuncellemeTarihiBitis
     * @return \StructType\UrunFiltre
     */
    public function setStokGuncellemeTarihiBitis($stokGuncellemeTarihiBitis = null)
    {
        // validation for constraint: string
        if (!is_null($stokGuncellemeTarihiBitis) && !is_string($stokGuncellemeTarihiBitis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stokGuncellemeTarihiBitis, true), gettype($stokGuncellemeTarihiBitis)), __LINE__);
        }
        if (is_null($stokGuncellemeTarihiBitis) || (is_array($stokGuncellemeTarihiBitis) && empty($stokGuncellemeTarihiBitis))) {
            unset($this->StokGuncellemeTarihiBitis);
        } else {
            $this->StokGuncellemeTarihiBitis = $stokGuncellemeTarihiBitis;
        }
        return $this;
    }
    /**
     * Get StokKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStokKodu()
    {
        return isset($this->StokKodu) ? $this->StokKodu : null;
    }
    /**
     * Set StokKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stokKodu
     * @return \StructType\UrunFiltre
     */
    public function setStokKodu($stokKodu = null)
    {
        // validation for constraint: string
        if (!is_null($stokKodu) && !is_string($stokKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stokKodu, true), gettype($stokKodu)), __LINE__);
        }
        if (is_null($stokKodu) || (is_array($stokKodu) && empty($stokKodu))) {
            unset($this->StokKodu);
        } else {
            $this->StokKodu = $stokKodu;
        }
        return $this;
    }
    /**
     * Get StokKoduList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getStokKoduList()
    {
        return isset($this->StokKoduList) ? $this->StokKoduList : null;
    }
    /**
     * Set StokKoduList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $stokKoduList
     * @return \StructType\UrunFiltre
     */
    public function setStokKoduList(\ArrayType\ArrayOfstring $stokKoduList = null)
    {
        if (is_null($stokKoduList) || (is_array($stokKoduList) && empty($stokKoduList))) {
            unset($this->StokKoduList);
        } else {
            $this->StokKoduList = $stokKoduList;
        }
        return $this;
    }
    /**
     * Get TedarikciID value
     * @return int|null
     */
    public function getTedarikciID()
    {
        return $this->TedarikciID;
    }
    /**
     * Set TedarikciID value
     * @param int $tedarikciID
     * @return \StructType\UrunFiltre
     */
    public function setTedarikciID($tedarikciID = null)
    {
        // validation for constraint: int
        if (!is_null($tedarikciID) && !(is_int($tedarikciID) || ctype_digit($tedarikciID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tedarikciID, true), gettype($tedarikciID)), __LINE__);
        }
        $this->TedarikciID = $tedarikciID;
        return $this;
    }
    /**
     * Get ToplamStokAdediBas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToplamStokAdediBas()
    {
        return isset($this->ToplamStokAdediBas) ? $this->ToplamStokAdediBas : null;
    }
    /**
     * Set ToplamStokAdediBas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toplamStokAdediBas
     * @return \StructType\UrunFiltre
     */
    public function setToplamStokAdediBas($toplamStokAdediBas = null)
    {
        // validation for constraint: float
        if (!is_null($toplamStokAdediBas) && !(is_float($toplamStokAdediBas) || is_numeric($toplamStokAdediBas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamStokAdediBas, true), gettype($toplamStokAdediBas)), __LINE__);
        }
        if (is_null($toplamStokAdediBas) || (is_array($toplamStokAdediBas) && empty($toplamStokAdediBas))) {
            unset($this->ToplamStokAdediBas);
        } else {
            $this->ToplamStokAdediBas = $toplamStokAdediBas;
        }
        return $this;
    }
    /**
     * Get ToplamStokAdediSon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToplamStokAdediSon()
    {
        return isset($this->ToplamStokAdediSon) ? $this->ToplamStokAdediSon : null;
    }
    /**
     * Set ToplamStokAdediSon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toplamStokAdediSon
     * @return \StructType\UrunFiltre
     */
    public function setToplamStokAdediSon($toplamStokAdediSon = null)
    {
        // validation for constraint: float
        if (!is_null($toplamStokAdediSon) && !(is_float($toplamStokAdediSon) || is_numeric($toplamStokAdediSon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toplamStokAdediSon, true), gettype($toplamStokAdediSon)), __LINE__);
        }
        if (is_null($toplamStokAdediSon) || (is_array($toplamStokAdediSon) && empty($toplamStokAdediSon))) {
            unset($this->ToplamStokAdediSon);
        } else {
            $this->ToplamStokAdediSon = $toplamStokAdediSon;
        }
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\UrunFiltre
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !(is_int($urunKartiID) || ctype_digit($urunKartiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiID, true), gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
    /**
     * Get Vitrin value
     * @return int|null
     */
    public function getVitrin()
    {
        return $this->Vitrin;
    }
    /**
     * Set Vitrin value
     * @param int $vitrin
     * @return \StructType\UrunFiltre
     */
    public function setVitrin($vitrin = null)
    {
        // validation for constraint: int
        if (!is_null($vitrin) && !(is_int($vitrin) || ctype_digit($vitrin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vitrin, true), gettype($vitrin)), __LINE__);
        }
        $this->Vitrin = $vitrin;
        return $this;
    }
}
