<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www6.aeat.es/static_files/common/internet/dep/aplicaciones/es/aeat/ssii_1_1_bis/fact/ws/SuministroFactRecibidas.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www6.aeat.es/static_files/common/internet/dep/aplicaciones/es/aeat/ssii_1_1_bis/fact/ws/SuministroFactRecibidas.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \ClonixDev\AeatSii\ClassMap::get(),
);
/**
 * Samples for Suministro ServiceType
 */
$suministro = new \ClonixDev\AeatSii\ServiceType\Suministro($options);
/**
 * Sample call for SuministroLRFacturasRecibidas operation/method
 */
if ($suministro->SuministroLRFacturasRecibidas(new \ClonixDev\AeatSii\StructType\SuministroLRFacturasRecibidas()) !== false) {
    print_r($suministro->getResult());
} else {
    print_r($suministro->getLastError());
}
/**
 * Samples for Anulacion ServiceType
 */
$anulacion = new \ClonixDev\AeatSii\ServiceType\Anulacion($options);
/**
 * Sample call for AnulacionLRFacturasRecibidas operation/method
 */
if ($anulacion->AnulacionLRFacturasRecibidas(new \ClonixDev\AeatSii\StructType\BajaLRFacturasRecibidas()) !== false) {
    print_r($anulacion->getResult());
} else {
    print_r($anulacion->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ClonixDev\AeatSii\ServiceType\Consulta($options);
/**
 * Sample call for ConsultaLRFacturasRecibidas operation/method
 */
if ($consulta->ConsultaLRFacturasRecibidas(new \ClonixDev\AeatSii\StructType\LRConsultaRecibidasType()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaLRFactInformadasProveedor operation/method
 */
if ($consulta->ConsultaLRFactInformadasProveedor(new \ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasProveedorType()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaLRFactInformadasAgrupadasProveedor operation/method
 */
if ($consulta->ConsultaLRFactInformadasAgrupadasProveedor(new \ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasAgrupadasProveedorType()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
