<?php

namespace ClonixDev\AeatSii\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaLRFacturasRecibidas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ClonixDev\AeatSii\StructType\LRConsultaRecibidasType $consultaLRFacturasRecibidas
     * @return \ClonixDev\AeatSii\StructType\RespuestaConsultaLRFacturasRecibidasType|bool
     */
    public function ConsultaLRFacturasRecibidas(\ClonixDev\AeatSii\StructType\LRConsultaRecibidasType $consultaLRFacturasRecibidas)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaLRFacturasRecibidas($consultaLRFacturasRecibidas));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaLRFactInformadasProveedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasProveedorType $consultaLRFactInformadasProveedor
     * @return \ClonixDev\AeatSii\StructType\RespuestaConsultaLRFactInformadasProveedorType|bool
     */
    public function ConsultaLRFactInformadasProveedor(\ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasProveedorType $consultaLRFactInformadasProveedor)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaLRFactInformadasProveedor($consultaLRFactInformadasProveedor));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultaLRFactInformadasAgrupadasProveedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasAgrupadasProveedorType $consultaLRFactInformadasAgrupadasProveedor
     * @return \ClonixDev\AeatSii\StructType\RespuestaConsultaLRFactInformadasAgrupadasProveedorType|bool
     */
    public function ConsultaLRFactInformadasAgrupadasProveedor(\ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasAgrupadasProveedorType $consultaLRFactInformadasAgrupadasProveedor)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaLRFactInformadasAgrupadasProveedor($consultaLRFactInformadasAgrupadasProveedor));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ClonixDev\AeatSii\StructType\RespuestaConsultaLRFactInformadasAgrupadasProveedorType|\ClonixDev\AeatSii\StructType\RespuestaConsultaLRFactInformadasProveedorType|\ClonixDev\AeatSii\StructType\RespuestaConsultaLRFacturasRecibidasType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
