<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www6.aeat.es/static_files/common/internet/dep/aplicaciones/es/aeat/ssii_1_1_bis/fact/ws/SuministroFactEmitidas.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www6.aeat.es/static_files/common/internet/dep/aplicaciones/es/aeat/ssii_1_1_bis/fact/ws/SuministroFactEmitidas.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \ClonixDev\AeatSii\ClassMap::get(),
);
/**
 * Samples for Suministro ServiceType
 */
$suministro = new \ClonixDev\AeatSii\ServiceType\Suministro($options);
/**
 * Sample call for SuministroLRFacturasEmitidas operation/method
 */
if ($suministro->SuministroLRFacturasEmitidas(new \ClonixDev\AeatSii\StructType\SuministroLRFacturasEmitidas()) !== false) {
    print_r($suministro->getResult());
} else {
    print_r($suministro->getLastError());
}
/**
 * Samples for Anulacion ServiceType
 */
$anulacion = new \ClonixDev\AeatSii\ServiceType\Anulacion($options);
/**
 * Sample call for AnulacionLRFacturasEmitidas operation/method
 */
if ($anulacion->AnulacionLRFacturasEmitidas(new \ClonixDev\AeatSii\StructType\BajaLRFacturasEmitidas()) !== false) {
    print_r($anulacion->getResult());
} else {
    print_r($anulacion->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ClonixDev\AeatSii\ServiceType\Consulta($options);
/**
 * Sample call for ConsultaLRFacturasEmitidas operation/method
 */
if ($consulta->ConsultaLRFacturasEmitidas(new \ClonixDev\AeatSii\StructType\LRConsultaEmitidasType()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaLRFactInformadasCliente operation/method
 */
if ($consulta->ConsultaLRFactInformadasCliente(new \ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasClienteType()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaLRFactInformadasAgrupadasCliente operation/method
 */
if ($consulta->ConsultaLRFactInformadasAgrupadasCliente(new \ClonixDev\AeatSii\StructType\ConsultaLRFactInformadasAgrupadasClienteType()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
