<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacturaRespuestaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Datos comunes de facturas emitidas y recibidas
 * @subpackage Structs
 */
class FacturaRespuestaType extends AbstractStructBase
{
    /**
     * The TipoFactura
     * Meta information extracted from the WSDL
     * - documentation: Clave del tipo de factura
     * @var string
     */
    public $TipoFactura;
    /**
     * The TipoRectificativa
     * Meta information extracted from the WSDL
     * - documentation: Clave del tipo de factura
     * - minOccurs: 0
     * @var string
     */
    public $TipoRectificativa;
    /**
     * The FacturasAgrupadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\FacturasAgrupadas
     */
    public $FacturasAgrupadas;
    /**
     * The FacturasRectificadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\FacturasRectificadas
     */
    public $FacturasRectificadas;
    /**
     * The ImporteRectificacion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\DesgloseRectificacionType
     */
    public $ImporteRectificacion;
    /**
     * The FechaOperacion
     * Meta information extracted from the WSDL
     * - base: string
     * - length: 10
     * - minOccurs: 0
     * - pattern: \d{2,2}-\d{2,2}-\d{4,4}
     * @var string
     */
    public $FechaOperacion;
    /**
     * The ClaveRegimenEspecialOTrascendencia
     * @var string
     */
    public $ClaveRegimenEspecialOTrascendencia;
    /**
     * The ClaveRegimenEspecialOTrascendenciaAdicional1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClaveRegimenEspecialOTrascendenciaAdicional1;
    /**
     * The ClaveRegimenEspecialOTrascendenciaAdicional2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClaveRegimenEspecialOTrascendenciaAdicional2;
    /**
     * The NumRegistroAcuerdoFacturacion
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - minOccurs: 0
     * @var string
     */
    public $NumRegistroAcuerdoFacturacion;
    /**
     * The ImporteTotal
     * Meta information extracted from the WSDL
     * - base: string
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $ImporteTotal;
    /**
     * The BaseImponibleACoste
     * Meta information extracted from the WSDL
     * - base: string
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $BaseImponibleACoste;
    /**
     * The DescripcionOperacion
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 500
     * @var string
     */
    public $DescripcionOperacion;
    /**
     * The RefExterna
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - minOccurs: 0
     * @var string
     */
    public $RefExterna;
    /**
     * The FacturaSimplificadaArticulos7_2_7_3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FacturaSimplificadaArticulos7_2_7_3;
    /**
     * The EntidadSucedida
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType
     */
    public $EntidadSucedida;
    /**
     * The RegPrevioGGEEoREDEMEoCompetencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegPrevioGGEEoREDEMEoCompetencia;
    /**
     * The Macrodato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Macrodato;
    /**
     * Constructor method for FacturaRespuestaType
     * @uses FacturaRespuestaType::setTipoFactura()
     * @uses FacturaRespuestaType::setTipoRectificativa()
     * @uses FacturaRespuestaType::setFacturasAgrupadas()
     * @uses FacturaRespuestaType::setFacturasRectificadas()
     * @uses FacturaRespuestaType::setImporteRectificacion()
     * @uses FacturaRespuestaType::setFechaOperacion()
     * @uses FacturaRespuestaType::setClaveRegimenEspecialOTrascendencia()
     * @uses FacturaRespuestaType::setClaveRegimenEspecialOTrascendenciaAdicional1()
     * @uses FacturaRespuestaType::setClaveRegimenEspecialOTrascendenciaAdicional2()
     * @uses FacturaRespuestaType::setNumRegistroAcuerdoFacturacion()
     * @uses FacturaRespuestaType::setImporteTotal()
     * @uses FacturaRespuestaType::setBaseImponibleACoste()
     * @uses FacturaRespuestaType::setDescripcionOperacion()
     * @uses FacturaRespuestaType::setRefExterna()
     * @uses FacturaRespuestaType::setFacturaSimplificadaArticulos7_2_7_3()
     * @uses FacturaRespuestaType::setEntidadSucedida()
     * @uses FacturaRespuestaType::setRegPrevioGGEEoREDEMEoCompetencia()
     * @uses FacturaRespuestaType::setMacrodato()
     * @param string $tipoFactura
     * @param string $tipoRectificativa
     * @param \clonixdev\aemetsii\StructType\FacturasAgrupadas $facturasAgrupadas
     * @param \clonixdev\aemetsii\StructType\FacturasRectificadas $facturasRectificadas
     * @param \clonixdev\aemetsii\StructType\DesgloseRectificacionType $importeRectificacion
     * @param string $fechaOperacion
     * @param string $claveRegimenEspecialOTrascendencia
     * @param string $claveRegimenEspecialOTrascendenciaAdicional1
     * @param string $claveRegimenEspecialOTrascendenciaAdicional2
     * @param string $numRegistroAcuerdoFacturacion
     * @param string $importeTotal
     * @param string $baseImponibleACoste
     * @param string $descripcionOperacion
     * @param string $refExterna
     * @param string $facturaSimplificadaArticulos7_2_7_3
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $entidadSucedida
     * @param string $regPrevioGGEEoREDEMEoCompetencia
     * @param string $macrodato
     */
    public function __construct($tipoFactura = null, $tipoRectificativa = null, \clonixdev\aemetsii\StructType\FacturasAgrupadas $facturasAgrupadas = null, \clonixdev\aemetsii\StructType\FacturasRectificadas $facturasRectificadas = null, \clonixdev\aemetsii\StructType\DesgloseRectificacionType $importeRectificacion = null, $fechaOperacion = null, $claveRegimenEspecialOTrascendencia = null, $claveRegimenEspecialOTrascendenciaAdicional1 = null, $claveRegimenEspecialOTrascendenciaAdicional2 = null, $numRegistroAcuerdoFacturacion = null, $importeTotal = null, $baseImponibleACoste = null, $descripcionOperacion = null, $refExterna = null, $facturaSimplificadaArticulos7_2_7_3 = null, \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $entidadSucedida = null, $regPrevioGGEEoREDEMEoCompetencia = null, $macrodato = null)
    {
        $this
            ->setTipoFactura($tipoFactura)
            ->setTipoRectificativa($tipoRectificativa)
            ->setFacturasAgrupadas($facturasAgrupadas)
            ->setFacturasRectificadas($facturasRectificadas)
            ->setImporteRectificacion($importeRectificacion)
            ->setFechaOperacion($fechaOperacion)
            ->setClaveRegimenEspecialOTrascendencia($claveRegimenEspecialOTrascendencia)
            ->setClaveRegimenEspecialOTrascendenciaAdicional1($claveRegimenEspecialOTrascendenciaAdicional1)
            ->setClaveRegimenEspecialOTrascendenciaAdicional2($claveRegimenEspecialOTrascendenciaAdicional2)
            ->setNumRegistroAcuerdoFacturacion($numRegistroAcuerdoFacturacion)
            ->setImporteTotal($importeTotal)
            ->setBaseImponibleACoste($baseImponibleACoste)
            ->setDescripcionOperacion($descripcionOperacion)
            ->setRefExterna($refExterna)
            ->setFacturaSimplificadaArticulos7_2_7_3($facturaSimplificadaArticulos7_2_7_3)
            ->setEntidadSucedida($entidadSucedida)
            ->setRegPrevioGGEEoREDEMEoCompetencia($regPrevioGGEEoREDEMEoCompetencia)
            ->setMacrodato($macrodato);
    }
    /**
     * Get TipoFactura value
     * @return string|null
     */
    public function getTipoFactura()
    {
        return $this->TipoFactura;
    }
    /**
     * Set TipoFactura value
     * @uses \clonixdev\aemetsii\EnumType\ClaveTipoFacturaType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\ClaveTipoFacturaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoFactura
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setTipoFactura($tipoFactura = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\ClaveTipoFacturaType::valueIsValid($tipoFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\ClaveTipoFacturaType', is_array($tipoFactura) ? implode(', ', $tipoFactura) : var_export($tipoFactura, true), implode(', ', \clonixdev\aemetsii\EnumType\ClaveTipoFacturaType::getValidValues())), __LINE__);
        }
        $this->TipoFactura = $tipoFactura;
        return $this;
    }
    /**
     * Get TipoRectificativa value
     * @return string|null
     */
    public function getTipoRectificativa()
    {
        return $this->TipoRectificativa;
    }
    /**
     * Set TipoRectificativa value
     * @uses \clonixdev\aemetsii\EnumType\ClaveTipoRectificativaType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\ClaveTipoRectificativaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRectificativa
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setTipoRectificativa($tipoRectificativa = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\ClaveTipoRectificativaType::valueIsValid($tipoRectificativa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\ClaveTipoRectificativaType', is_array($tipoRectificativa) ? implode(', ', $tipoRectificativa) : var_export($tipoRectificativa, true), implode(', ', \clonixdev\aemetsii\EnumType\ClaveTipoRectificativaType::getValidValues())), __LINE__);
        }
        $this->TipoRectificativa = $tipoRectificativa;
        return $this;
    }
    /**
     * Get FacturasAgrupadas value
     * @return \clonixdev\aemetsii\StructType\FacturasAgrupadas|null
     */
    public function getFacturasAgrupadas()
    {
        return $this->FacturasAgrupadas;
    }
    /**
     * Set FacturasAgrupadas value
     * @param \clonixdev\aemetsii\StructType\FacturasAgrupadas $facturasAgrupadas
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setFacturasAgrupadas(\clonixdev\aemetsii\StructType\FacturasAgrupadas $facturasAgrupadas = null)
    {
        $this->FacturasAgrupadas = $facturasAgrupadas;
        return $this;
    }
    /**
     * Get FacturasRectificadas value
     * @return \clonixdev\aemetsii\StructType\FacturasRectificadas|null
     */
    public function getFacturasRectificadas()
    {
        return $this->FacturasRectificadas;
    }
    /**
     * Set FacturasRectificadas value
     * @param \clonixdev\aemetsii\StructType\FacturasRectificadas $facturasRectificadas
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setFacturasRectificadas(\clonixdev\aemetsii\StructType\FacturasRectificadas $facturasRectificadas = null)
    {
        $this->FacturasRectificadas = $facturasRectificadas;
        return $this;
    }
    /**
     * Get ImporteRectificacion value
     * @return \clonixdev\aemetsii\StructType\DesgloseRectificacionType|null
     */
    public function getImporteRectificacion()
    {
        return $this->ImporteRectificacion;
    }
    /**
     * Set ImporteRectificacion value
     * @param \clonixdev\aemetsii\StructType\DesgloseRectificacionType $importeRectificacion
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setImporteRectificacion(\clonixdev\aemetsii\StructType\DesgloseRectificacionType $importeRectificacion = null)
    {
        $this->ImporteRectificacion = $importeRectificacion;
        return $this;
    }
    /**
     * Get FechaOperacion value
     * @return string|null
     */
    public function getFechaOperacion()
    {
        return $this->FechaOperacion;
    }
    /**
     * Set FechaOperacion value
     * @param string $fechaOperacion
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setFechaOperacion($fechaOperacion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaOperacion) && !is_string($fechaOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaOperacion, true), gettype($fechaOperacion)), __LINE__);
        }
        // validation for constraint: length(10)
        if (!is_null($fechaOperacion) && mb_strlen($fechaOperacion) !== 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 10', mb_strlen($fechaOperacion)), __LINE__);
        }
        // validation for constraint: pattern(\d{2,2}-\d{2,2}-\d{4,4})
        if (!is_null($fechaOperacion) && !preg_match('/\\d{2,2}-\\d{2,2}-\\d{4,4}/', $fechaOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{2,2}-\d{2,2}-\d{4,4}', var_export($fechaOperacion, true)), __LINE__);
        }
        $this->FechaOperacion = $fechaOperacion;
        return $this;
    }
    /**
     * Get ClaveRegimenEspecialOTrascendencia value
     * @return string|null
     */
    public function getClaveRegimenEspecialOTrascendencia()
    {
        return $this->ClaveRegimenEspecialOTrascendencia;
    }
    /**
     * Set ClaveRegimenEspecialOTrascendencia value
     * @uses \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claveRegimenEspecialOTrascendencia
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setClaveRegimenEspecialOTrascendencia($claveRegimenEspecialOTrascendencia = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid($claveRegimenEspecialOTrascendencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType', is_array($claveRegimenEspecialOTrascendencia) ? implode(', ', $claveRegimenEspecialOTrascendencia) : var_export($claveRegimenEspecialOTrascendencia, true), implode(', ', \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues())), __LINE__);
        }
        $this->ClaveRegimenEspecialOTrascendencia = $claveRegimenEspecialOTrascendencia;
        return $this;
    }
    /**
     * Get ClaveRegimenEspecialOTrascendenciaAdicional1 value
     * @return string|null
     */
    public function getClaveRegimenEspecialOTrascendenciaAdicional1()
    {
        return $this->ClaveRegimenEspecialOTrascendenciaAdicional1;
    }
    /**
     * Set ClaveRegimenEspecialOTrascendenciaAdicional1 value
     * @uses \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claveRegimenEspecialOTrascendenciaAdicional1
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setClaveRegimenEspecialOTrascendenciaAdicional1($claveRegimenEspecialOTrascendenciaAdicional1 = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid($claveRegimenEspecialOTrascendenciaAdicional1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType', is_array($claveRegimenEspecialOTrascendenciaAdicional1) ? implode(', ', $claveRegimenEspecialOTrascendenciaAdicional1) : var_export($claveRegimenEspecialOTrascendenciaAdicional1, true), implode(', ', \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues())), __LINE__);
        }
        $this->ClaveRegimenEspecialOTrascendenciaAdicional1 = $claveRegimenEspecialOTrascendenciaAdicional1;
        return $this;
    }
    /**
     * Get ClaveRegimenEspecialOTrascendenciaAdicional2 value
     * @return string|null
     */
    public function getClaveRegimenEspecialOTrascendenciaAdicional2()
    {
        return $this->ClaveRegimenEspecialOTrascendenciaAdicional2;
    }
    /**
     * Set ClaveRegimenEspecialOTrascendenciaAdicional2 value
     * @uses \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claveRegimenEspecialOTrascendenciaAdicional2
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setClaveRegimenEspecialOTrascendenciaAdicional2($claveRegimenEspecialOTrascendenciaAdicional2 = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::valueIsValid($claveRegimenEspecialOTrascendenciaAdicional2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType', is_array($claveRegimenEspecialOTrascendenciaAdicional2) ? implode(', ', $claveRegimenEspecialOTrascendenciaAdicional2) : var_export($claveRegimenEspecialOTrascendenciaAdicional2, true), implode(', ', \clonixdev\aemetsii\EnumType\IdOperacionesTrascendenciaTributariaType::getValidValues())), __LINE__);
        }
        $this->ClaveRegimenEspecialOTrascendenciaAdicional2 = $claveRegimenEspecialOTrascendenciaAdicional2;
        return $this;
    }
    /**
     * Get NumRegistroAcuerdoFacturacion value
     * @return string|null
     */
    public function getNumRegistroAcuerdoFacturacion()
    {
        return $this->NumRegistroAcuerdoFacturacion;
    }
    /**
     * Set NumRegistroAcuerdoFacturacion value
     * @param string $numRegistroAcuerdoFacturacion
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setNumRegistroAcuerdoFacturacion($numRegistroAcuerdoFacturacion = null)
    {
        // validation for constraint: string
        if (!is_null($numRegistroAcuerdoFacturacion) && !is_string($numRegistroAcuerdoFacturacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numRegistroAcuerdoFacturacion, true), gettype($numRegistroAcuerdoFacturacion)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($numRegistroAcuerdoFacturacion) && mb_strlen($numRegistroAcuerdoFacturacion) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($numRegistroAcuerdoFacturacion)), __LINE__);
        }
        $this->NumRegistroAcuerdoFacturacion = $numRegistroAcuerdoFacturacion;
        return $this;
    }
    /**
     * Get ImporteTotal value
     * @return string|null
     */
    public function getImporteTotal()
    {
        return $this->ImporteTotal;
    }
    /**
     * Set ImporteTotal value
     * @param string $importeTotal
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setImporteTotal($importeTotal = null)
    {
        // validation for constraint: string
        if (!is_null($importeTotal) && !is_string($importeTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importeTotal, true), gettype($importeTotal)), __LINE__);
        }
        // validation for constraint: pattern((\+|-)?\d{1,12}(\.\d{0,2})?)
        if (!is_null($importeTotal) && !preg_match('/(\\+|-)?\\d{1,12}(\\.\\d{0,2})?/', $importeTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (\+|-)?\d{1,12}(\.\d{0,2})?', var_export($importeTotal, true)), __LINE__);
        }
        $this->ImporteTotal = $importeTotal;
        return $this;
    }
    /**
     * Get BaseImponibleACoste value
     * @return string|null
     */
    public function getBaseImponibleACoste()
    {
        return $this->BaseImponibleACoste;
    }
    /**
     * Set BaseImponibleACoste value
     * @param string $baseImponibleACoste
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setBaseImponibleACoste($baseImponibleACoste = null)
    {
        // validation for constraint: string
        if (!is_null($baseImponibleACoste) && !is_string($baseImponibleACoste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseImponibleACoste, true), gettype($baseImponibleACoste)), __LINE__);
        }
        // validation for constraint: pattern((\+|-)?\d{1,12}(\.\d{0,2})?)
        if (!is_null($baseImponibleACoste) && !preg_match('/(\\+|-)?\\d{1,12}(\\.\\d{0,2})?/', $baseImponibleACoste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (\+|-)?\d{1,12}(\.\d{0,2})?', var_export($baseImponibleACoste, true)), __LINE__);
        }
        $this->BaseImponibleACoste = $baseImponibleACoste;
        return $this;
    }
    /**
     * Get DescripcionOperacion value
     * @return string|null
     */
    public function getDescripcionOperacion()
    {
        return $this->DescripcionOperacion;
    }
    /**
     * Set DescripcionOperacion value
     * @param string $descripcionOperacion
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setDescripcionOperacion($descripcionOperacion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcionOperacion) && !is_string($descripcionOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcionOperacion, true), gettype($descripcionOperacion)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($descripcionOperacion) && mb_strlen($descripcionOperacion) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($descripcionOperacion)), __LINE__);
        }
        $this->DescripcionOperacion = $descripcionOperacion;
        return $this;
    }
    /**
     * Get RefExterna value
     * @return string|null
     */
    public function getRefExterna()
    {
        return $this->RefExterna;
    }
    /**
     * Set RefExterna value
     * @param string $refExterna
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setRefExterna($refExterna = null)
    {
        // validation for constraint: string
        if (!is_null($refExterna) && !is_string($refExterna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refExterna, true), gettype($refExterna)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($refExterna) && mb_strlen($refExterna) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($refExterna)), __LINE__);
        }
        $this->RefExterna = $refExterna;
        return $this;
    }
    /**
     * Get facturaSimplificadaArticulos7 value
     * @return facturaSimplificadaArticulos7
     */
    public function getFacturaSimplificadaArticulos7_2_7_3()
    {
        return $this->{'FacturaSimplificadaArticulos7.2_7.3'};
    }
    /**
     * Set facturaSimplificadaArticulos7 value
     * @param facturaSimplificadaArticulos7 $facturaSimplificadaArticulos7
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setFacturaSimplificadaArticulos7_2_7_3($facturaSimplificadaArticulos7_2_7_3 = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\SimplificadaCualificadaType::valueIsValid($facturaSimplificadaArticulos7_2_7_3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\SimplificadaCualificadaType', is_array($facturaSimplificadaArticulos7_2_7_3) ? implode(', ', $facturaSimplificadaArticulos7_2_7_3) : var_export($facturaSimplificadaArticulos7_2_7_3, true), implode(', ', \clonixdev\aemetsii\EnumType\SimplificadaCualificadaType::getValidValues())), __LINE__);
        }
        $this->FacturaSimplificadaArticulos7_2_7_3 = $this->{'FacturaSimplificadaArticulos7.2_7.3'} = $facturaSimplificadaArticulos7_2_7_3;
        return $this;
    }
    /**
     * Get EntidadSucedida value
     * @return \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType|null
     */
    public function getEntidadSucedida()
    {
        return $this->EntidadSucedida;
    }
    /**
     * Set EntidadSucedida value
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $entidadSucedida
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setEntidadSucedida(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $entidadSucedida = null)
    {
        $this->EntidadSucedida = $entidadSucedida;
        return $this;
    }
    /**
     * Get RegPrevioGGEEoREDEMEoCompetencia value
     * @return string|null
     */
    public function getRegPrevioGGEEoREDEMEoCompetencia()
    {
        return $this->RegPrevioGGEEoREDEMEoCompetencia;
    }
    /**
     * Set RegPrevioGGEEoREDEMEoCompetencia value
     * @uses \clonixdev\aemetsii\EnumType\RegPrevioGGEEoREDEMEoCompetenciaType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\RegPrevioGGEEoREDEMEoCompetenciaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regPrevioGGEEoREDEMEoCompetencia
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setRegPrevioGGEEoREDEMEoCompetencia($regPrevioGGEEoREDEMEoCompetencia = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\RegPrevioGGEEoREDEMEoCompetenciaType::valueIsValid($regPrevioGGEEoREDEMEoCompetencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\RegPrevioGGEEoREDEMEoCompetenciaType', is_array($regPrevioGGEEoREDEMEoCompetencia) ? implode(', ', $regPrevioGGEEoREDEMEoCompetencia) : var_export($regPrevioGGEEoREDEMEoCompetencia, true), implode(', ', \clonixdev\aemetsii\EnumType\RegPrevioGGEEoREDEMEoCompetenciaType::getValidValues())), __LINE__);
        }
        $this->RegPrevioGGEEoREDEMEoCompetencia = $regPrevioGGEEoREDEMEoCompetencia;
        return $this;
    }
    /**
     * Get Macrodato value
     * @return string|null
     */
    public function getMacrodato()
    {
        return $this->Macrodato;
    }
    /**
     * Set Macrodato value
     * @uses \clonixdev\aemetsii\EnumType\MacrodatoType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\MacrodatoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $macrodato
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaType
     */
    public function setMacrodato($macrodato = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\MacrodatoType::valueIsValid($macrodato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\MacrodatoType', is_array($macrodato) ? implode(', ', $macrodato) : var_export($macrodato, true), implode(', ', \clonixdev\aemetsii\EnumType\MacrodatoType::getValidValues())), __LINE__);
        }
        $this->Macrodato = $macrodato;
        return $this;
    }
}
