<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRFiltroFactInformadasClienteType StructType
 * @subpackage Structs
 */
class LRFiltroFactInformadasClienteType extends RegistroSiiImputacion
{
    /**
     * The Cliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType
     */
    public $Cliente;
    /**
     * The NumSerieFacturaEmisor
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumSerieFacturaEmisor;
    /**
     * The EstadoCuadre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EstadoCuadre;
    /**
     * The FechaExpedicion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\RangoFechaType
     */
    public $FechaExpedicion;
    /**
     * The FechaOperacion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\RangoFechaType
     */
    public $FechaOperacion;
    /**
     * The ClavePaginacion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\ClavePaginacionClienteType
     */
    public $ClavePaginacion;
    /**
     * Constructor method for LRFiltroFactInformadasClienteType
     * @uses LRFiltroFactInformadasClienteType::setCliente()
     * @uses LRFiltroFactInformadasClienteType::setNumSerieFacturaEmisor()
     * @uses LRFiltroFactInformadasClienteType::setEstadoCuadre()
     * @uses LRFiltroFactInformadasClienteType::setFechaExpedicion()
     * @uses LRFiltroFactInformadasClienteType::setFechaOperacion()
     * @uses LRFiltroFactInformadasClienteType::setClavePaginacion()
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $cliente
     * @param string $numSerieFacturaEmisor
     * @param string $estadoCuadre
     * @param \clonixdev\aemetsii\StructType\RangoFechaType $fechaExpedicion
     * @param \clonixdev\aemetsii\StructType\RangoFechaType $fechaOperacion
     * @param \clonixdev\aemetsii\StructType\ClavePaginacionClienteType $clavePaginacion
     */
    public function __construct(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $cliente = null, $numSerieFacturaEmisor = null, $estadoCuadre = null, \clonixdev\aemetsii\StructType\RangoFechaType $fechaExpedicion = null, \clonixdev\aemetsii\StructType\RangoFechaType $fechaOperacion = null, \clonixdev\aemetsii\StructType\ClavePaginacionClienteType $clavePaginacion = null)
    {
        $this
            ->setCliente($cliente)
            ->setNumSerieFacturaEmisor($numSerieFacturaEmisor)
            ->setEstadoCuadre($estadoCuadre)
            ->setFechaExpedicion($fechaExpedicion)
            ->setFechaOperacion($fechaOperacion)
            ->setClavePaginacion($clavePaginacion);
    }
    /**
     * Get Cliente value
     * @return \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType|null
     */
    public function getCliente()
    {
        return $this->Cliente;
    }
    /**
     * Set Cliente value
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $cliente
     * @return \clonixdev\aemetsii\StructType\LRFiltroFactInformadasClienteType
     */
    public function setCliente(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $cliente = null)
    {
        $this->Cliente = $cliente;
        return $this;
    }
    /**
     * Get NumSerieFacturaEmisor value
     * @return string|null
     */
    public function getNumSerieFacturaEmisor()
    {
        return $this->NumSerieFacturaEmisor;
    }
    /**
     * Set NumSerieFacturaEmisor value
     * @param string $numSerieFacturaEmisor
     * @return \clonixdev\aemetsii\StructType\LRFiltroFactInformadasClienteType
     */
    public function setNumSerieFacturaEmisor($numSerieFacturaEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($numSerieFacturaEmisor) && !is_string($numSerieFacturaEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numSerieFacturaEmisor, true), gettype($numSerieFacturaEmisor)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($numSerieFacturaEmisor) && mb_strlen($numSerieFacturaEmisor) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($numSerieFacturaEmisor)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numSerieFacturaEmisor) && mb_strlen($numSerieFacturaEmisor) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numSerieFacturaEmisor)), __LINE__);
        }
        $this->NumSerieFacturaEmisor = $numSerieFacturaEmisor;
        return $this;
    }
    /**
     * Get EstadoCuadre value
     * @return string|null
     */
    public function getEstadoCuadre()
    {
        return $this->EstadoCuadre;
    }
    /**
     * Set EstadoCuadre value
     * @uses \clonixdev\aemetsii\EnumType\EstadoCuadreImputacionType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\EstadoCuadreImputacionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estadoCuadre
     * @return \clonixdev\aemetsii\StructType\LRFiltroFactInformadasClienteType
     */
    public function setEstadoCuadre($estadoCuadre = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\EstadoCuadreImputacionType::valueIsValid($estadoCuadre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\EstadoCuadreImputacionType', is_array($estadoCuadre) ? implode(', ', $estadoCuadre) : var_export($estadoCuadre, true), implode(', ', \clonixdev\aemetsii\EnumType\EstadoCuadreImputacionType::getValidValues())), __LINE__);
        }
        $this->EstadoCuadre = $estadoCuadre;
        return $this;
    }
    /**
     * Get FechaExpedicion value
     * @return \clonixdev\aemetsii\StructType\RangoFechaType|null
     */
    public function getFechaExpedicion()
    {
        return $this->FechaExpedicion;
    }
    /**
     * Set FechaExpedicion value
     * @param \clonixdev\aemetsii\StructType\RangoFechaType $fechaExpedicion
     * @return \clonixdev\aemetsii\StructType\LRFiltroFactInformadasClienteType
     */
    public function setFechaExpedicion(\clonixdev\aemetsii\StructType\RangoFechaType $fechaExpedicion = null)
    {
        $this->FechaExpedicion = $fechaExpedicion;
        return $this;
    }
    /**
     * Get FechaOperacion value
     * @return \clonixdev\aemetsii\StructType\RangoFechaType|null
     */
    public function getFechaOperacion()
    {
        return $this->FechaOperacion;
    }
    /**
     * Set FechaOperacion value
     * @param \clonixdev\aemetsii\StructType\RangoFechaType $fechaOperacion
     * @return \clonixdev\aemetsii\StructType\LRFiltroFactInformadasClienteType
     */
    public function setFechaOperacion(\clonixdev\aemetsii\StructType\RangoFechaType $fechaOperacion = null)
    {
        $this->FechaOperacion = $fechaOperacion;
        return $this;
    }
    /**
     * Get ClavePaginacion value
     * @return \clonixdev\aemetsii\StructType\ClavePaginacionClienteType|null
     */
    public function getClavePaginacion()
    {
        return $this->ClavePaginacion;
    }
    /**
     * Set ClavePaginacion value
     * @param \clonixdev\aemetsii\StructType\ClavePaginacionClienteType $clavePaginacion
     * @return \clonixdev\aemetsii\StructType\LRFiltroFactInformadasClienteType
     */
    public function setClavePaginacion(\clonixdev\aemetsii\StructType\ClavePaginacionClienteType $clavePaginacion = null)
    {
        $this->ClavePaginacion = $clavePaginacion;
        return $this;
    }
}
