<?php

namespace clonixdev\aemetsii\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaLRFacturasEmitidas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \clonixdev\aemetsii\StructType\LRConsultaEmitidasType $consultaLRFacturasEmitidas
     * @return \clonixdev\aemetsii\StructType\RespuestaConsultaLRFacturasEmitidasType|bool
     */
    public function ConsultaLRFacturasEmitidas(\clonixdev\aemetsii\StructType\LRConsultaEmitidasType $consultaLRFacturasEmitidas)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaLRFacturasEmitidas($consultaLRFacturasEmitidas));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaLRFactInformadasCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \clonixdev\aemetsii\StructType\ConsultaLRFactInformadasClienteType $consultaLRFactInformadasCliente
     * @return \clonixdev\aemetsii\StructType\RespuestaConsultaLRFactInformadasClienteType|bool
     */
    public function ConsultaLRFactInformadasCliente(\clonixdev\aemetsii\StructType\ConsultaLRFactInformadasClienteType $consultaLRFactInformadasCliente)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaLRFactInformadasCliente($consultaLRFactInformadasCliente));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultaLRFactInformadasAgrupadasCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \clonixdev\aemetsii\StructType\ConsultaLRFactInformadasAgrupadasClienteType $consultaLRFactInformadasAgrupadasCliente
     * @return \clonixdev\aemetsii\StructType\RespuestaConsultaLRFactInformadasAgrupadasClienteType|bool
     */
    public function ConsultaLRFactInformadasAgrupadasCliente(\clonixdev\aemetsii\StructType\ConsultaLRFactInformadasAgrupadasClienteType $consultaLRFactInformadasAgrupadasCliente)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaLRFactInformadasAgrupadasCliente($consultaLRFactInformadasAgrupadasCliente));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \clonixdev\aemetsii\StructType\RespuestaConsultaLRFactInformadasAgrupadasClienteType|\clonixdev\aemetsii\StructType\RespuestaConsultaLRFactInformadasClienteType|\clonixdev\aemetsii\StructType\RespuestaConsultaLRFacturasEmitidasType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
