<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaInmueblesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Respuesta a un envío Sii de baja
 * @subpackage Structs
 */
class RespuestaInmueblesType extends AbstractStructBase
{
    /**
     * The CSV
     * Meta information extracted from the WSDL
     * - documentation: CSV asociado al envío generado por AEAT. Solo se genera si no hay rechazo del envio
     * - minOccurs: 0
     * @var string
     */
    public $CSV;
    /**
     * The DatosPresentacion
     * Meta information extracted from the WSDL
     * - documentation: Se devuelven datos de la presentacion realizada. Solo se genera si no hay rechazo del envio
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\DatosPresentacionType
     */
    public $DatosPresentacion;
    /**
     * The Cabecera
     * Meta information extracted from the WSDL
     * - documentation: Se devuelve la cabecera que se incluó en el envío.
     * @var \clonixdev\aemetsii\StructType\CabeceraSiiCobrosPagos
     */
    public $Cabecera;
    /**
     * The EstadoEnvio
     * Meta information extracted from the WSDL
     * - documentation: Estado del envío en conjunto. Si los datos de cabecera y todos los registros son correctos,el estado es correcto. En caso de estructura y cabecera correctos donde todos los registros son incorrectos, el estado es incorrecto En caso
     * de estructura y cabecera correctos con al menos un registro incorrecto o aceptado con errores, el estado global es parcialmente correcto.
     * @var string
     */
    public $EstadoEnvio;
    /**
     * Constructor method for RespuestaInmueblesType
     * @uses RespuestaInmueblesType::setCSV()
     * @uses RespuestaInmueblesType::setDatosPresentacion()
     * @uses RespuestaInmueblesType::setCabecera()
     * @uses RespuestaInmueblesType::setEstadoEnvio()
     * @param string $cSV
     * @param \clonixdev\aemetsii\StructType\DatosPresentacionType $datosPresentacion
     * @param \clonixdev\aemetsii\StructType\CabeceraSiiCobrosPagos $cabecera
     * @param string $estadoEnvio
     */
    public function __construct($cSV = null, \clonixdev\aemetsii\StructType\DatosPresentacionType $datosPresentacion = null, \clonixdev\aemetsii\StructType\CabeceraSiiCobrosPagos $cabecera = null, $estadoEnvio = null)
    {
        $this
            ->setCSV($cSV)
            ->setDatosPresentacion($datosPresentacion)
            ->setCabecera($cabecera)
            ->setEstadoEnvio($estadoEnvio);
    }
    /**
     * Get CSV value
     * @return string|null
     */
    public function getCSV()
    {
        return $this->CSV;
    }
    /**
     * Set CSV value
     * @param string $cSV
     * @return \clonixdev\aemetsii\StructType\RespuestaInmueblesType
     */
    public function setCSV($cSV = null)
    {
        // validation for constraint: string
        if (!is_null($cSV) && !is_string($cSV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSV, true), gettype($cSV)), __LINE__);
        }
        $this->CSV = $cSV;
        return $this;
    }
    /**
     * Get DatosPresentacion value
     * @return \clonixdev\aemetsii\StructType\DatosPresentacionType|null
     */
    public function getDatosPresentacion()
    {
        return $this->DatosPresentacion;
    }
    /**
     * Set DatosPresentacion value
     * @param \clonixdev\aemetsii\StructType\DatosPresentacionType $datosPresentacion
     * @return \clonixdev\aemetsii\StructType\RespuestaInmueblesType
     */
    public function setDatosPresentacion(\clonixdev\aemetsii\StructType\DatosPresentacionType $datosPresentacion = null)
    {
        $this->DatosPresentacion = $datosPresentacion;
        return $this;
    }
    /**
     * Get Cabecera value
     * @return \clonixdev\aemetsii\StructType\CabeceraSiiCobrosPagos|null
     */
    public function getCabecera()
    {
        return $this->Cabecera;
    }
    /**
     * Set Cabecera value
     * @param \clonixdev\aemetsii\StructType\CabeceraSiiCobrosPagos $cabecera
     * @return \clonixdev\aemetsii\StructType\RespuestaInmueblesType
     */
    public function setCabecera(\clonixdev\aemetsii\StructType\CabeceraSiiCobrosPagos $cabecera = null)
    {
        $this->Cabecera = $cabecera;
        return $this;
    }
    /**
     * Get EstadoEnvio value
     * @return string|null
     */
    public function getEstadoEnvio()
    {
        return $this->EstadoEnvio;
    }
    /**
     * Set EstadoEnvio value
     * @uses \clonixdev\aemetsii\EnumType\EstadoEnvioType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\EstadoEnvioType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estadoEnvio
     * @return \clonixdev\aemetsii\StructType\RespuestaInmueblesType
     */
    public function setEstadoEnvio($estadoEnvio = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\EstadoEnvioType::valueIsValid($estadoEnvio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\EstadoEnvioType', is_array($estadoEnvio) ? implode(', ', $estadoEnvio) : var_export($estadoEnvio, true), implode(', ', \clonixdev\aemetsii\EnumType\EstadoEnvioType::getValidValues())), __LINE__);
        }
        $this->EstadoEnvio = $estadoEnvio;
        return $this;
    }
}
