<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoExenta StructType
 * @subpackage Structs
 */
class NoExenta extends AbstractStructBase
{
    /**
     * The TipoNoExenta
     * @var string
     */
    public $TipoNoExenta;
    /**
     * The DesgloseIVA
     * @var \clonixdev\aemetsii\StructType\DesgloseIVA
     */
    public $DesgloseIVA;
    /**
     * Constructor method for NoExenta
     * @uses NoExenta::setTipoNoExenta()
     * @uses NoExenta::setDesgloseIVA()
     * @param string $tipoNoExenta
     * @param \clonixdev\aemetsii\StructType\DesgloseIVA $desgloseIVA
     */
    public function __construct($tipoNoExenta = null, \clonixdev\aemetsii\StructType\DesgloseIVA $desgloseIVA = null)
    {
        $this
            ->setTipoNoExenta($tipoNoExenta)
            ->setDesgloseIVA($desgloseIVA);
    }
    /**
     * Get TipoNoExenta value
     * @return string|null
     */
    public function getTipoNoExenta()
    {
        return $this->TipoNoExenta;
    }
    /**
     * Set TipoNoExenta value
     * @uses \clonixdev\aemetsii\EnumType\TipoOperacionSujetaNoExentaType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\TipoOperacionSujetaNoExentaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoNoExenta
     * @return \clonixdev\aemetsii\StructType\NoExenta
     */
    public function setTipoNoExenta($tipoNoExenta = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\TipoOperacionSujetaNoExentaType::valueIsValid($tipoNoExenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\TipoOperacionSujetaNoExentaType', is_array($tipoNoExenta) ? implode(', ', $tipoNoExenta) : var_export($tipoNoExenta, true), implode(', ', \clonixdev\aemetsii\EnumType\TipoOperacionSujetaNoExentaType::getValidValues())), __LINE__);
        }
        $this->TipoNoExenta = $tipoNoExenta;
        return $this;
    }
    /**
     * Get DesgloseIVA value
     * @return \clonixdev\aemetsii\StructType\DesgloseIVA|null
     */
    public function getDesgloseIVA()
    {
        return $this->DesgloseIVA;
    }
    /**
     * Set DesgloseIVA value
     * @param \clonixdev\aemetsii\StructType\DesgloseIVA $desgloseIVA
     * @return \clonixdev\aemetsii\StructType\NoExenta
     */
    public function setDesgloseIVA(\clonixdev\aemetsii\StructType\DesgloseIVA $desgloseIVA = null)
    {
        $this->DesgloseIVA = $desgloseIVA;
        return $this;
    }
}
