<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRVentaBienesConsignaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de venta de bienes en consigna.
 * @subpackage Structs
 */
class LRVentaBienesConsignaType extends AbstractStructBase
{
    /**
     * The ClaveDeclarante
     * @var string
     */
    public $ClaveDeclarante;
    /**
     * The IdRegistroDeclarado
     * @var \clonixdev\aemetsii\StructType\IdRegistroDeclaradoType
     */
    public $IdRegistroDeclarado;
    /**
     * The TipoOperacion
     * @var string
     */
    public $TipoOperacion;
    /**
     * The Contraparte
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType
     */
    public $Contraparte;
    /**
     * The SustitutoDestinatarioInicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType
     */
    public $SustitutoDestinatarioInicial;
    /**
     * The Deposito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\DepositoType
     */
    public $Deposito;
    /**
     * The OperacionIntracomunitaria
     * @var \clonixdev\aemetsii\StructType\VentaBienesConsignaType
     */
    public $OperacionIntracomunitaria;
    /**
     * Constructor method for LRVentaBienesConsignaType
     * @uses LRVentaBienesConsignaType::setClaveDeclarante()
     * @uses LRVentaBienesConsignaType::setIdRegistroDeclarado()
     * @uses LRVentaBienesConsignaType::setTipoOperacion()
     * @uses LRVentaBienesConsignaType::setContraparte()
     * @uses LRVentaBienesConsignaType::setSustitutoDestinatarioInicial()
     * @uses LRVentaBienesConsignaType::setDeposito()
     * @uses LRVentaBienesConsignaType::setOperacionIntracomunitaria()
     * @param string $claveDeclarante
     * @param \clonixdev\aemetsii\StructType\IdRegistroDeclaradoType $idRegistroDeclarado
     * @param string $tipoOperacion
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $sustitutoDestinatarioInicial
     * @param \clonixdev\aemetsii\StructType\DepositoType $deposito
     * @param \clonixdev\aemetsii\StructType\VentaBienesConsignaType $operacionIntracomunitaria
     */
    public function __construct($claveDeclarante = null, \clonixdev\aemetsii\StructType\IdRegistroDeclaradoType $idRegistroDeclarado = null, $tipoOperacion = null, \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte = null, \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $sustitutoDestinatarioInicial = null, \clonixdev\aemetsii\StructType\DepositoType $deposito = null, \clonixdev\aemetsii\StructType\VentaBienesConsignaType $operacionIntracomunitaria = null)
    {
        $this
            ->setClaveDeclarante($claveDeclarante)
            ->setIdRegistroDeclarado($idRegistroDeclarado)
            ->setTipoOperacion($tipoOperacion)
            ->setContraparte($contraparte)
            ->setSustitutoDestinatarioInicial($sustitutoDestinatarioInicial)
            ->setDeposito($deposito)
            ->setOperacionIntracomunitaria($operacionIntracomunitaria);
    }
    /**
     * Get ClaveDeclarante value
     * @return string|null
     */
    public function getClaveDeclarante()
    {
        return $this->ClaveDeclarante;
    }
    /**
     * Set ClaveDeclarante value
     * @uses \clonixdev\aemetsii\EnumType\TipoClaveDeclaranteType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\TipoClaveDeclaranteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claveDeclarante
     * @return \clonixdev\aemetsii\StructType\LRVentaBienesConsignaType
     */
    public function setClaveDeclarante($claveDeclarante = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\TipoClaveDeclaranteType::valueIsValid($claveDeclarante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\TipoClaveDeclaranteType', is_array($claveDeclarante) ? implode(', ', $claveDeclarante) : var_export($claveDeclarante, true), implode(', ', \clonixdev\aemetsii\EnumType\TipoClaveDeclaranteType::getValidValues())), __LINE__);
        }
        $this->ClaveDeclarante = $claveDeclarante;
        return $this;
    }
    /**
     * Get IdRegistroDeclarado value
     * @return \clonixdev\aemetsii\StructType\IdRegistroDeclaradoType|null
     */
    public function getIdRegistroDeclarado()
    {
        return $this->IdRegistroDeclarado;
    }
    /**
     * Set IdRegistroDeclarado value
     * @param \clonixdev\aemetsii\StructType\IdRegistroDeclaradoType $idRegistroDeclarado
     * @return \clonixdev\aemetsii\StructType\LRVentaBienesConsignaType
     */
    public function setIdRegistroDeclarado(\clonixdev\aemetsii\StructType\IdRegistroDeclaradoType $idRegistroDeclarado = null)
    {
        $this->IdRegistroDeclarado = $idRegistroDeclarado;
        return $this;
    }
    /**
     * Get TipoOperacion value
     * @return string|null
     */
    public function getTipoOperacion()
    {
        return $this->TipoOperacion;
    }
    /**
     * Set TipoOperacion value
     * @uses \clonixdev\aemetsii\EnumType\TipoOperacionType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\TipoOperacionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoOperacion
     * @return \clonixdev\aemetsii\StructType\LRVentaBienesConsignaType
     */
    public function setTipoOperacion($tipoOperacion = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\TipoOperacionType::valueIsValid($tipoOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\TipoOperacionType', is_array($tipoOperacion) ? implode(', ', $tipoOperacion) : var_export($tipoOperacion, true), implode(', ', \clonixdev\aemetsii\EnumType\TipoOperacionType::getValidValues())), __LINE__);
        }
        $this->TipoOperacion = $tipoOperacion;
        return $this;
    }
    /**
     * Get Contraparte value
     * @return \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType|null
     */
    public function getContraparte()
    {
        return $this->Contraparte;
    }
    /**
     * Set Contraparte value
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte
     * @return \clonixdev\aemetsii\StructType\LRVentaBienesConsignaType
     */
    public function setContraparte(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte = null)
    {
        $this->Contraparte = $contraparte;
        return $this;
    }
    /**
     * Get SustitutoDestinatarioInicial value
     * @return \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType|null
     */
    public function getSustitutoDestinatarioInicial()
    {
        return $this->SustitutoDestinatarioInicial;
    }
    /**
     * Set SustitutoDestinatarioInicial value
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $sustitutoDestinatarioInicial
     * @return \clonixdev\aemetsii\StructType\LRVentaBienesConsignaType
     */
    public function setSustitutoDestinatarioInicial(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $sustitutoDestinatarioInicial = null)
    {
        $this->SustitutoDestinatarioInicial = $sustitutoDestinatarioInicial;
        return $this;
    }
    /**
     * Get Deposito value
     * @return \clonixdev\aemetsii\StructType\DepositoType|null
     */
    public function getDeposito()
    {
        return $this->Deposito;
    }
    /**
     * Set Deposito value
     * @param \clonixdev\aemetsii\StructType\DepositoType $deposito
     * @return \clonixdev\aemetsii\StructType\LRVentaBienesConsignaType
     */
    public function setDeposito(\clonixdev\aemetsii\StructType\DepositoType $deposito = null)
    {
        $this->Deposito = $deposito;
        return $this;
    }
    /**
     * Get OperacionIntracomunitaria value
     * @return \clonixdev\aemetsii\StructType\VentaBienesConsignaType|null
     */
    public function getOperacionIntracomunitaria()
    {
        return $this->OperacionIntracomunitaria;
    }
    /**
     * Set OperacionIntracomunitaria value
     * @param \clonixdev\aemetsii\StructType\VentaBienesConsignaType $operacionIntracomunitaria
     * @return \clonixdev\aemetsii\StructType\LRVentaBienesConsignaType
     */
    public function setOperacionIntracomunitaria(\clonixdev\aemetsii\StructType\VentaBienesConsignaType $operacionIntracomunitaria = null)
    {
        $this->OperacionIntracomunitaria = $operacionIntracomunitaria;
        return $this;
    }
}
