<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacturaRespuestaExpedidaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Apunte correspondiente al libro de facturas expedidas.
 * @subpackage Structs
 */
class FacturaRespuestaExpedidaType extends FacturaRespuestaType
{
    /**
     * The DatosInmueble
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\DatosInmueble
     */
    public $DatosInmueble;
    /**
     * The ImporteTransmisionInmueblesSujetoAIVA
     * Meta information extracted from the WSDL
     * - base: string
     * - minOccurs: 0
     * - pattern: (\+|-)?\d{1,12}(\.\d{0,2})?
     * @var string
     */
    public $ImporteTransmisionInmueblesSujetoAIVA;
    /**
     * The EmitidaPorTercerosODestinatario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EmitidaPorTercerosODestinatario;
    /**
     * The FacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas;
    /**
     * The VariosDestinatarios
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VariosDestinatarios;
    /**
     * The Cupon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Cupon;
    /**
     * The FacturaSinIdentifDestinatarioAritculo6_1_d
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FacturaSinIdentifDestinatarioAritculo6_1_d;
    /**
     * The Contraparte
     * Meta information extracted from the WSDL
     * - documentation: Contraparte de la operación. Cliente (Opcional en tiquets) en facturas emitidas.
     * - minOccurs: 0
     * @var \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType
     */
    public $Contraparte;
    /**
     * The TipoDesglose
     * @var \clonixdev\aemetsii\StructType\TipoDesglose
     */
    public $TipoDesglose;
    /**
     * The Cobros
     * @var string
     */
    public $Cobros;
    /**
     * Constructor method for FacturaRespuestaExpedidaType
     * @uses FacturaRespuestaExpedidaType::setDatosInmueble()
     * @uses FacturaRespuestaExpedidaType::setImporteTransmisionInmueblesSujetoAIVA()
     * @uses FacturaRespuestaExpedidaType::setEmitidaPorTercerosODestinatario()
     * @uses FacturaRespuestaExpedidaType::setFacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas()
     * @uses FacturaRespuestaExpedidaType::setVariosDestinatarios()
     * @uses FacturaRespuestaExpedidaType::setCupon()
     * @uses FacturaRespuestaExpedidaType::setFacturaSinIdentifDestinatarioAritculo6_1_d()
     * @uses FacturaRespuestaExpedidaType::setContraparte()
     * @uses FacturaRespuestaExpedidaType::setTipoDesglose()
     * @uses FacturaRespuestaExpedidaType::setCobros()
     * @param \clonixdev\aemetsii\StructType\DatosInmueble $datosInmueble
     * @param string $importeTransmisionInmueblesSujetoAIVA
     * @param string $emitidaPorTercerosODestinatario
     * @param string $facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas
     * @param string $variosDestinatarios
     * @param string $cupon
     * @param string $facturaSinIdentifDestinatarioAritculo6_1_d
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte
     * @param \clonixdev\aemetsii\StructType\TipoDesglose $tipoDesglose
     * @param string $cobros
     */
    public function __construct(\clonixdev\aemetsii\StructType\DatosInmueble $datosInmueble = null, $importeTransmisionInmueblesSujetoAIVA = null, $emitidaPorTercerosODestinatario = null, $facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas = null, $variosDestinatarios = null, $cupon = null, $facturaSinIdentifDestinatarioAritculo6_1_d = null, \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte = null, \clonixdev\aemetsii\StructType\TipoDesglose $tipoDesglose = null, $cobros = null)
    {
        $this
            ->setDatosInmueble($datosInmueble)
            ->setImporteTransmisionInmueblesSujetoAIVA($importeTransmisionInmueblesSujetoAIVA)
            ->setEmitidaPorTercerosODestinatario($emitidaPorTercerosODestinatario)
            ->setFacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas($facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas)
            ->setVariosDestinatarios($variosDestinatarios)
            ->setCupon($cupon)
            ->setFacturaSinIdentifDestinatarioAritculo6_1_d($facturaSinIdentifDestinatarioAritculo6_1_d)
            ->setContraparte($contraparte)
            ->setTipoDesglose($tipoDesglose)
            ->setCobros($cobros);
    }
    /**
     * Get DatosInmueble value
     * @return \clonixdev\aemetsii\StructType\DatosInmueble|null
     */
    public function getDatosInmueble()
    {
        return $this->DatosInmueble;
    }
    /**
     * Set DatosInmueble value
     * @param \clonixdev\aemetsii\StructType\DatosInmueble $datosInmueble
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setDatosInmueble(\clonixdev\aemetsii\StructType\DatosInmueble $datosInmueble = null)
    {
        $this->DatosInmueble = $datosInmueble;
        return $this;
    }
    /**
     * Get ImporteTransmisionInmueblesSujetoAIVA value
     * @return string|null
     */
    public function getImporteTransmisionInmueblesSujetoAIVA()
    {
        return $this->ImporteTransmisionInmueblesSujetoAIVA;
    }
    /**
     * Set ImporteTransmisionInmueblesSujetoAIVA value
     * @param string $importeTransmisionInmueblesSujetoAIVA
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setImporteTransmisionInmueblesSujetoAIVA($importeTransmisionInmueblesSujetoAIVA = null)
    {
        // validation for constraint: string
        if (!is_null($importeTransmisionInmueblesSujetoAIVA) && !is_string($importeTransmisionInmueblesSujetoAIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importeTransmisionInmueblesSujetoAIVA, true), gettype($importeTransmisionInmueblesSujetoAIVA)), __LINE__);
        }
        // validation for constraint: pattern((\+|-)?\d{1,12}(\.\d{0,2})?)
        if (!is_null($importeTransmisionInmueblesSujetoAIVA) && !preg_match('/(\\+|-)?\\d{1,12}(\\.\\d{0,2})?/', $importeTransmisionInmueblesSujetoAIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (\+|-)?\d{1,12}(\.\d{0,2})?', var_export($importeTransmisionInmueblesSujetoAIVA, true)), __LINE__);
        }
        $this->ImporteTransmisionInmueblesSujetoAIVA = $importeTransmisionInmueblesSujetoAIVA;
        return $this;
    }
    /**
     * Get EmitidaPorTercerosODestinatario value
     * @return string|null
     */
    public function getEmitidaPorTercerosODestinatario()
    {
        return $this->EmitidaPorTercerosODestinatario;
    }
    /**
     * Set EmitidaPorTercerosODestinatario value
     * @uses \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emitidaPorTercerosODestinatario
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setEmitidaPorTercerosODestinatario($emitidaPorTercerosODestinatario = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::valueIsValid($emitidaPorTercerosODestinatario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType', is_array($emitidaPorTercerosODestinatario) ? implode(', ', $emitidaPorTercerosODestinatario) : var_export($emitidaPorTercerosODestinatario, true), implode(', ', \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::getValidValues())), __LINE__);
        }
        $this->EmitidaPorTercerosODestinatario = $emitidaPorTercerosODestinatario;
        return $this;
    }
    /**
     * Get FacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas value
     * @return string|null
     */
    public function getFacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas()
    {
        return $this->FacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas;
    }
    /**
     * Set FacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas value
     * @uses \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setFacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas($facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::valueIsValid($facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType', is_array($facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas) ? implode(', ', $facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas) : var_export($facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas, true), implode(', ', \clonixdev\aemetsii\EnumType\EmitidaPorTercerosType::getValidValues())), __LINE__);
        }
        $this->FacturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas = $facturacionDispAdicionalTerceraYsextayDelMercadoOrganizadoDelGas;
        return $this;
    }
    /**
     * Get VariosDestinatarios value
     * @return string|null
     */
    public function getVariosDestinatarios()
    {
        return $this->VariosDestinatarios;
    }
    /**
     * Set VariosDestinatarios value
     * @uses \clonixdev\aemetsii\EnumType\VariosDestinatariosType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\VariosDestinatariosType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $variosDestinatarios
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setVariosDestinatarios($variosDestinatarios = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\VariosDestinatariosType::valueIsValid($variosDestinatarios)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\VariosDestinatariosType', is_array($variosDestinatarios) ? implode(', ', $variosDestinatarios) : var_export($variosDestinatarios, true), implode(', ', \clonixdev\aemetsii\EnumType\VariosDestinatariosType::getValidValues())), __LINE__);
        }
        $this->VariosDestinatarios = $variosDestinatarios;
        return $this;
    }
    /**
     * Get Cupon value
     * @return string|null
     */
    public function getCupon()
    {
        return $this->Cupon;
    }
    /**
     * Set Cupon value
     * @uses \clonixdev\aemetsii\EnumType\CuponType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\CuponType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cupon
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setCupon($cupon = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\CuponType::valueIsValid($cupon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\CuponType', is_array($cupon) ? implode(', ', $cupon) : var_export($cupon, true), implode(', ', \clonixdev\aemetsii\EnumType\CuponType::getValidValues())), __LINE__);
        }
        $this->Cupon = $cupon;
        return $this;
    }
    /**
     * Get facturaSinIdentifDestinatarioAritculo6_d value
     * @return facturaSinIdentifDestinatarioAritculo6_d
     */
    public function getFacturaSinIdentifDestinatarioAritculo6_1_d()
    {
        return $this->{'FacturaSinIdentifDestinatarioAritculo6.1.d'};
    }
    /**
     * Set facturaSinIdentifDestinatarioAritculo6_d value
     * @param facturaSinIdentifDestinatarioAritculo6_d $facturaSinIdentifDestinatarioAritculo6_d
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setFacturaSinIdentifDestinatarioAritculo6_1_d($facturaSinIdentifDestinatarioAritculo6_1_d = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\CompletaSinDestinatarioType::valueIsValid($facturaSinIdentifDestinatarioAritculo6_1_d)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\CompletaSinDestinatarioType', is_array($facturaSinIdentifDestinatarioAritculo6_1_d) ? implode(', ', $facturaSinIdentifDestinatarioAritculo6_1_d) : var_export($facturaSinIdentifDestinatarioAritculo6_1_d, true), implode(', ', \clonixdev\aemetsii\EnumType\CompletaSinDestinatarioType::getValidValues())), __LINE__);
        }
        $this->FacturaSinIdentifDestinatarioAritculo6_1_d = $this->{'FacturaSinIdentifDestinatarioAritculo6.1.d'} = $facturaSinIdentifDestinatarioAritculo6_1_d;
        return $this;
    }
    /**
     * Get Contraparte value
     * @return \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType|null
     */
    public function getContraparte()
    {
        return $this->Contraparte;
    }
    /**
     * Set Contraparte value
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setContraparte(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaType $contraparte = null)
    {
        $this->Contraparte = $contraparte;
        return $this;
    }
    /**
     * Get TipoDesglose value
     * @return \clonixdev\aemetsii\StructType\TipoDesglose|null
     */
    public function getTipoDesglose()
    {
        return $this->TipoDesglose;
    }
    /**
     * Set TipoDesglose value
     * @param \clonixdev\aemetsii\StructType\TipoDesglose $tipoDesglose
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setTipoDesglose(\clonixdev\aemetsii\StructType\TipoDesglose $tipoDesglose = null)
    {
        $this->TipoDesglose = $tipoDesglose;
        return $this;
    }
    /**
     * Get Cobros value
     * @return string|null
     */
    public function getCobros()
    {
        return $this->Cobros;
    }
    /**
     * Set Cobros value
     * @uses \clonixdev\aemetsii\EnumType\FacturaARType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\FacturaARType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cobros
     * @return \clonixdev\aemetsii\StructType\FacturaRespuestaExpedidaType
     */
    public function setCobros($cobros = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\FacturaARType::valueIsValid($cobros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\FacturaARType', is_array($cobros) ? implode(', ', $cobros) : var_export($cobros, true), implode(', ', \clonixdev\aemetsii\EnumType\FacturaARType::getValidValues())), __LINE__);
        }
        $this->Cobros = $cobros;
        return $this;
    }
}
