<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabeceraSiiBaja StructType
 * Meta information extracted from the WSDL
 * - documentation: Datos de contexto de un suministro sin especificar el timpo de comunicacion
 * @subpackage Structs
 */
class CabeceraSiiBaja extends AbstractStructBase
{
    /**
     * The IDVersionSii
     * @var string
     */
    public $IDVersionSii;
    /**
     * The Titular
     * Meta information extracted from the WSDL
     * - documentation: Titular de los libros de registro que suministra la información
     * @var \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaESType
     */
    public $Titular;
    /**
     * Constructor method for CabeceraSiiBaja
     * @uses CabeceraSiiBaja::setIDVersionSii()
     * @uses CabeceraSiiBaja::setTitular()
     * @param string $iDVersionSii
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaESType $titular
     */
    public function __construct($iDVersionSii = null, \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaESType $titular = null)
    {
        $this
            ->setIDVersionSii($iDVersionSii)
            ->setTitular($titular);
    }
    /**
     * Get IDVersionSii value
     * @return string|null
     */
    public function getIDVersionSii()
    {
        return $this->IDVersionSii;
    }
    /**
     * Set IDVersionSii value
     * @uses \clonixdev\aemetsii\EnumType\VersionSiiType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\VersionSiiType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDVersionSii
     * @return \clonixdev\aemetsii\StructType\CabeceraSiiBaja
     */
    public function setIDVersionSii($iDVersionSii = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\VersionSiiType::valueIsValid($iDVersionSii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\VersionSiiType', is_array($iDVersionSii) ? implode(', ', $iDVersionSii) : var_export($iDVersionSii, true), implode(', ', \clonixdev\aemetsii\EnumType\VersionSiiType::getValidValues())), __LINE__);
        }
        $this->IDVersionSii = $iDVersionSii;
        return $this;
    }
    /**
     * Get Titular value
     * @return \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaESType|null
     */
    public function getTitular()
    {
        return $this->Titular;
    }
    /**
     * Set Titular value
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaESType $titular
     * @return \clonixdev\aemetsii\StructType\CabeceraSiiBaja
     */
    public function setTitular(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaESType $titular = null)
    {
        $this->Titular = $titular;
        return $this;
    }
}
