<?php

namespace clonixdev\aemetsii\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabeceraConsultaSii StructType
 * Meta information extracted from the WSDL
 * - documentation: Datos de contexto de un suministro sin especificar el tipo de comunicacion
 * @subpackage Structs
 */
class CabeceraConsultaSii extends AbstractStructBase
{
    /**
     * The IDVersionSii
     * @var string
     */
    public $IDVersionSii;
    /**
     * The Titular
     * Meta information extracted from the WSDL
     * - documentation: Titular de los libros de registro que suministra la información
     * @var \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType
     */
    public $Titular;
    /**
     * Constructor method for CabeceraConsultaSii
     * @uses CabeceraConsultaSii::setIDVersionSii()
     * @uses CabeceraConsultaSii::setTitular()
     * @param string $iDVersionSii
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $titular
     */
    public function __construct($iDVersionSii = null, \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $titular = null)
    {
        $this
            ->setIDVersionSii($iDVersionSii)
            ->setTitular($titular);
    }
    /**
     * Get IDVersionSii value
     * @return string|null
     */
    public function getIDVersionSii()
    {
        return $this->IDVersionSii;
    }
    /**
     * Set IDVersionSii value
     * @uses \clonixdev\aemetsii\EnumType\VersionSiiType::valueIsValid()
     * @uses \clonixdev\aemetsii\EnumType\VersionSiiType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDVersionSii
     * @return \clonixdev\aemetsii\StructType\CabeceraConsultaSii
     */
    public function setIDVersionSii($iDVersionSii = null)
    {
        // validation for constraint: enumeration
        if (!\clonixdev\aemetsii\EnumType\VersionSiiType::valueIsValid($iDVersionSii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \clonixdev\aemetsii\EnumType\VersionSiiType', is_array($iDVersionSii) ? implode(', ', $iDVersionSii) : var_export($iDVersionSii, true), implode(', ', \clonixdev\aemetsii\EnumType\VersionSiiType::getValidValues())), __LINE__);
        }
        $this->IDVersionSii = $iDVersionSii;
        return $this;
    }
    /**
     * Get Titular value
     * @return \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType|null
     */
    public function getTitular()
    {
        return $this->Titular;
    }
    /**
     * Set Titular value
     * @param \clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $titular
     * @return \clonixdev\aemetsii\StructType\CabeceraConsultaSii
     */
    public function setTitular(\clonixdev\aemetsii\StructType\PersonaFisicaJuridicaUnicaESType $titular = null)
    {
        $this->Titular = $titular;
        return $this;
    }
}
