<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.sandbox.tipalti.com/v9/payerfunctions.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.sandbox.tipalti.com/v9/payerfunctions.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreatePaymentOrdersReport operation/method
 */
if ($create->CreatePaymentOrdersReport(new \StructType\CreatePaymentOrdersReport()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateExtendedPayeeStatusFile operation/method
 */
if ($create->CreateExtendedPayeeStatusFile(new \StructType\CreateExtendedPayeeStatusFile()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePayeeStatusFile operation/method
 */
if ($create->CreatePayeeStatusFile(new \StructType\CreatePayeeStatusFile()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdateInvoices operation/method
 */
if ($create->CreateOrUpdateInvoices(new \StructType\CreateOrUpdateInvoices()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdateGLAccounts operation/method
 */
if ($create->CreateOrUpdateGLAccounts(new \StructType\CreateOrUpdateGLAccounts()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdateCustomFields operation/method
 */
if ($create->CreateOrUpdateCustomFields(new \StructType\CreateOrUpdateCustomFields()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdateCustomFieldValue operation/method
 */
if ($create->CreateOrUpdateCustomFieldValue(new \StructType\CreateOrUpdateCustomFieldValue()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdateGrns operation/method
 */
if ($create->CreateOrUpdateGrns(new \StructType\CreateOrUpdateGrns()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdatePurchaseOrders operation/method
 */
if ($create->CreateOrUpdatePurchaseOrders(new \StructType\CreateOrUpdatePurchaseOrders()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdatePaymentTerms operation/method
 */
if ($create->CreateOrUpdatePaymentTerms(new \StructType\CreateOrUpdatePaymentTerms()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdateTaxCodes operation/method
 */
if ($create->CreateOrUpdateTaxCodes(new \StructType\CreateOrUpdateTaxCodes()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for TestPaymentFile operation/method
 */
if ($test->TestPaymentFile(new \StructType\TestPaymentFile()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Sample call for TestMultiCurrencyPaymentFile operation/method
 */
if ($test->TestMultiCurrencyPaymentFile(new \StructType\TestMultiCurrencyPaymentFile()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Sample call for TestPayments operation/method
 */
if ($test->TestPayments(new \StructType\TestPayments()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Sample call for TestPaymentsAsync operation/method
 */
if ($test->TestPaymentsAsync(new \StructType\TestPaymentsAsync()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Sample call for TestPaymentFileAsync operation/method
 */
if ($test->TestPaymentFileAsync(new \StructType\TestPaymentFileAsync()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Sample call for TestMultiCurrencyPaymentFileAsync operation/method
 */
if ($test->TestMultiCurrencyPaymentFileAsync(new \StructType\TestMultiCurrencyPaymentFileAsync()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \ServiceType\Process($options);
/**
 * Sample call for ProcessPaymentFile operation/method
 */
if ($process->ProcessPaymentFile(new \StructType\ProcessPaymentFile()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessMultiCurrencyPaymentFile operation/method
 */
if ($process->ProcessMultiCurrencyPaymentFile(new \StructType\ProcessMultiCurrencyPaymentFile()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPayments operation/method
 */
if ($process->ProcessPayments(new \StructType\ProcessPayments()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPaymentsAsync operation/method
 */
if ($process->ProcessPaymentsAsync(new \StructType\ProcessPaymentsAsync()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPaymentFileAsync operation/method
 */
if ($process->ProcessPaymentFileAsync(new \StructType\ProcessPaymentFileAsync()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessMultiCurrencyPaymentFileAsync operation/method
 */
if ($process->ProcessMultiCurrencyPaymentFileAsync(new \StructType\ProcessMultiCurrencyPaymentFileAsync()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessPaymentsAsyncResult operation/method
 */
if ($process->ProcessPaymentsAsyncResult(new \StructType\ProcessPaymentsAsyncResult()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCustomFields operation/method
 */
if ($get->GetCustomFields(new \StructType\GetCustomFields()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProviderAccounts operation/method
 */
if ($get->GetProviderAccounts(new \StructType\GetProviderAccounts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDynamicKeyOfSubPayer operation/method
 */
if ($get->GetDynamicKeyOfSubPayer(new \StructType\GetDynamicKeyOfSubPayer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProcessingRequestStatus operation/method
 */
if ($get->GetProcessingRequestStatus(new \StructType\GetProcessingRequestStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDynamicKey operation/method
 */
if ($get->GetDynamicKey(new \StructType\GetDynamicKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBalances operation/method
 */
if ($get->GetBalances(new \StructType\GetBalances()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpdatedPayments operation/method
 */
if ($get->GetUpdatedPayments(new \StructType\GetUpdatedPayments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPayerFees operation/method
 */
if ($get->GetPayerFees(new \StructType\GetPayerFees()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPayeeInvoicesListDetails operation/method
 */
if ($get->GetPayeeInvoicesListDetails(new \StructType\GetPayeeInvoicesListDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPaymentTerms operation/method
 */
if ($get->GetPaymentTerms(new \StructType\GetPaymentTerms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPayerEntities operation/method
 */
if ($get->GetPayerEntities(new \StructType\GetPayerEntities()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPayeeInvoiceFile operation/method
 */
if ($get->GetPayeeInvoiceFile(new \StructType\GetPayeeInvoiceFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Log ServiceType
 */
$log = new \ServiceType\Log($options);
/**
 * Sample call for LogIntegrationError operation/method
 */
if ($log->LogIntegrationError(new \StructType\LogIntegrationError()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Samples for Apply ServiceType
 */
$apply = new \ServiceType\Apply($options);
/**
 * Sample call for ApplyVendorCredit operation/method
 */
if ($apply->ApplyVendorCredit(new \StructType\ApplyVendorCredit()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeletePaymentTerms operation/method
 */
if ($delete->DeletePaymentTerms(new \StructType\DeletePaymentTerms()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
