<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiTaxCode StructType
 * @subpackage Structs
 */
class TipaltiTaxCode extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Rate;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PayerEntities
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PayerEntities;
    /**
     * Constructor method for TipaltiTaxCode
     * @uses TipaltiTaxCode::setActive()
     * @uses TipaltiTaxCode::setRate()
     * @uses TipaltiTaxCode::setExternalId()
     * @uses TipaltiTaxCode::setName()
     * @uses TipaltiTaxCode::setPayerEntities()
     * @param bool $active
     * @param float $rate
     * @param string $externalId
     * @param string $name
     * @param \ArrayType\ArrayOfString $payerEntities
     */
    public function __construct($active = null, $rate = null, $externalId = null, $name = null, \ArrayType\ArrayOfString $payerEntities = null)
    {
        $this
            ->setActive($active)
            ->setRate($rate)
            ->setExternalId($externalId)
            ->setName($name)
            ->setPayerEntities($payerEntities);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\TipaltiTaxCode
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\TipaltiTaxCode
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get ExternalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->ExternalId;
    }
    /**
     * Set ExternalId value
     * @param string $externalId
     * @return \StructType\TipaltiTaxCode
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->ExternalId = $externalId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\TipaltiTaxCode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PayerEntities value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPayerEntities()
    {
        return $this->PayerEntities;
    }
    /**
     * Set PayerEntities value
     * @param \ArrayType\ArrayOfString $payerEntities
     * @return \StructType\TipaltiTaxCode
     */
    public function setPayerEntities(\ArrayType\ArrayOfString $payerEntities = null)
    {
        $this->PayerEntities = $payerEntities;
        return $this;
    }
}
