<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiSummaryAmounts StructType
 * @subpackage Structs
 */
class TipaltiSummaryAmounts extends AbstractStructBase
{
    /**
     * The totalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $totalAmount;
    /**
     * The immediateAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $immediateAmount;
    /**
     * The payableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $payableAmount;
    /**
     * The payerFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $payerFees;
    /**
     * The scheduledAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $scheduledAmount;
    /**
     * The outstandingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $outstandingAmount;
    /**
     * The withholdingAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $withholdingAmount;
    /**
     * The estimatedProviderFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $estimatedProviderFees;
    /**
     * The summaryRowCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $summaryRowCurrency;
    /**
     * Constructor method for TipaltiSummaryAmounts
     * @uses TipaltiSummaryAmounts::setTotalAmount()
     * @uses TipaltiSummaryAmounts::setImmediateAmount()
     * @uses TipaltiSummaryAmounts::setPayableAmount()
     * @uses TipaltiSummaryAmounts::setPayerFees()
     * @uses TipaltiSummaryAmounts::setScheduledAmount()
     * @uses TipaltiSummaryAmounts::setOutstandingAmount()
     * @uses TipaltiSummaryAmounts::setWithholdingAmount()
     * @uses TipaltiSummaryAmounts::setEstimatedProviderFees()
     * @uses TipaltiSummaryAmounts::setSummaryRowCurrency()
     * @param float $totalAmount
     * @param float $immediateAmount
     * @param float $payableAmount
     * @param float $payerFees
     * @param float $scheduledAmount
     * @param float $outstandingAmount
     * @param float $withholdingAmount
     * @param float $estimatedProviderFees
     * @param string $summaryRowCurrency
     */
    public function __construct($totalAmount = null, $immediateAmount = null, $payableAmount = null, $payerFees = null, $scheduledAmount = null, $outstandingAmount = null, $withholdingAmount = null, $estimatedProviderFees = null, $summaryRowCurrency = null)
    {
        $this
            ->setTotalAmount($totalAmount)
            ->setImmediateAmount($immediateAmount)
            ->setPayableAmount($payableAmount)
            ->setPayerFees($payerFees)
            ->setScheduledAmount($scheduledAmount)
            ->setOutstandingAmount($outstandingAmount)
            ->setWithholdingAmount($withholdingAmount)
            ->setEstimatedProviderFees($estimatedProviderFees)
            ->setSummaryRowCurrency($summaryRowCurrency);
    }
    /**
     * Get totalAmount value
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get immediateAmount value
     * @return float
     */
    public function getImmediateAmount()
    {
        return $this->immediateAmount;
    }
    /**
     * Set immediateAmount value
     * @param float $immediateAmount
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setImmediateAmount($immediateAmount = null)
    {
        // validation for constraint: float
        if (!is_null($immediateAmount) && !(is_float($immediateAmount) || is_numeric($immediateAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($immediateAmount, true), gettype($immediateAmount)), __LINE__);
        }
        $this->immediateAmount = $immediateAmount;
        return $this;
    }
    /**
     * Get payableAmount value
     * @return float
     */
    public function getPayableAmount()
    {
        return $this->payableAmount;
    }
    /**
     * Set payableAmount value
     * @param float $payableAmount
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setPayableAmount($payableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($payableAmount) && !(is_float($payableAmount) || is_numeric($payableAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payableAmount, true), gettype($payableAmount)), __LINE__);
        }
        $this->payableAmount = $payableAmount;
        return $this;
    }
    /**
     * Get payerFees value
     * @return float
     */
    public function getPayerFees()
    {
        return $this->payerFees;
    }
    /**
     * Set payerFees value
     * @param float $payerFees
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setPayerFees($payerFees = null)
    {
        // validation for constraint: float
        if (!is_null($payerFees) && !(is_float($payerFees) || is_numeric($payerFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payerFees, true), gettype($payerFees)), __LINE__);
        }
        $this->payerFees = $payerFees;
        return $this;
    }
    /**
     * Get scheduledAmount value
     * @return float
     */
    public function getScheduledAmount()
    {
        return $this->scheduledAmount;
    }
    /**
     * Set scheduledAmount value
     * @param float $scheduledAmount
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setScheduledAmount($scheduledAmount = null)
    {
        // validation for constraint: float
        if (!is_null($scheduledAmount) && !(is_float($scheduledAmount) || is_numeric($scheduledAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduledAmount, true), gettype($scheduledAmount)), __LINE__);
        }
        $this->scheduledAmount = $scheduledAmount;
        return $this;
    }
    /**
     * Get outstandingAmount value
     * @return float
     */
    public function getOutstandingAmount()
    {
        return $this->outstandingAmount;
    }
    /**
     * Set outstandingAmount value
     * @param float $outstandingAmount
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setOutstandingAmount($outstandingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($outstandingAmount) && !(is_float($outstandingAmount) || is_numeric($outstandingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($outstandingAmount, true), gettype($outstandingAmount)), __LINE__);
        }
        $this->outstandingAmount = $outstandingAmount;
        return $this;
    }
    /**
     * Get withholdingAmount value
     * @return float
     */
    public function getWithholdingAmount()
    {
        return $this->withholdingAmount;
    }
    /**
     * Set withholdingAmount value
     * @param float $withholdingAmount
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setWithholdingAmount($withholdingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($withholdingAmount) && !(is_float($withholdingAmount) || is_numeric($withholdingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($withholdingAmount, true), gettype($withholdingAmount)), __LINE__);
        }
        $this->withholdingAmount = $withholdingAmount;
        return $this;
    }
    /**
     * Get estimatedProviderFees value
     * @return float
     */
    public function getEstimatedProviderFees()
    {
        return $this->estimatedProviderFees;
    }
    /**
     * Set estimatedProviderFees value
     * @param float $estimatedProviderFees
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setEstimatedProviderFees($estimatedProviderFees = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedProviderFees) && !(is_float($estimatedProviderFees) || is_numeric($estimatedProviderFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedProviderFees, true), gettype($estimatedProviderFees)), __LINE__);
        }
        $this->estimatedProviderFees = $estimatedProviderFees;
        return $this;
    }
    /**
     * Get summaryRowCurrency value
     * @return string|null
     */
    public function getSummaryRowCurrency()
    {
        return $this->summaryRowCurrency;
    }
    /**
     * Set summaryRowCurrency value
     * @param string $summaryRowCurrency
     * @return \StructType\TipaltiSummaryAmounts
     */
    public function setSummaryRowCurrency($summaryRowCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($summaryRowCurrency) && !is_string($summaryRowCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summaryRowCurrency, true), gettype($summaryRowCurrency)), __LINE__);
        }
        $this->summaryRowCurrency = $summaryRowCurrency;
        return $this;
    }
}
