<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipaltiResponse StructType
 * @subpackage Structs
 */
class TipaltiResponse extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $errorCode;
    /**
     * The b
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $b;
    /**
     * The i
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i;
    /**
     * The d
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $d;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The s
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $s;
    /**
     * Constructor method for TipaltiResponse
     * @uses TipaltiResponse::setErrorCode()
     * @uses TipaltiResponse::setB()
     * @uses TipaltiResponse::setI()
     * @uses TipaltiResponse::setD()
     * @uses TipaltiResponse::setErrorMessage()
     * @uses TipaltiResponse::setS()
     * @param string $errorCode
     * @param bool $b
     * @param int $i
     * @param float $d
     * @param string $errorMessage
     * @param string $s
     */
    public function __construct($errorCode = null, $b = null, $i = null, $d = null, $errorMessage = null, $s = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setB($b)
            ->setI($i)
            ->setD($d)
            ->setErrorMessage($errorMessage)
            ->setS($s);
    }
    /**
     * Get errorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\WSErrors::valueIsValid()
     * @uses \EnumType\WSErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TipaltiResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WSErrors::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WSErrors', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\WSErrors::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get b value
     * @return bool
     */
    public function getB()
    {
        return $this->b;
    }
    /**
     * Set b value
     * @param bool $b
     * @return \StructType\TipaltiResponse
     */
    public function setB($b = null)
    {
        // validation for constraint: boolean
        if (!is_null($b) && !is_bool($b)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($b, true), gettype($b)), __LINE__);
        }
        $this->b = $b;
        return $this;
    }
    /**
     * Get i value
     * @return int
     */
    public function getI()
    {
        return $this->i;
    }
    /**
     * Set i value
     * @param int $i
     * @return \StructType\TipaltiResponse
     */
    public function setI($i = null)
    {
        // validation for constraint: int
        if (!is_null($i) && !(is_int($i) || ctype_digit($i))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($i, true), gettype($i)), __LINE__);
        }
        $this->i = $i;
        return $this;
    }
    /**
     * Get d value
     * @return float
     */
    public function getD()
    {
        return $this->d;
    }
    /**
     * Set d value
     * @param float $d
     * @return \StructType\TipaltiResponse
     */
    public function setD($d = null)
    {
        // validation for constraint: float
        if (!is_null($d) && !(is_float($d) || is_numeric($d))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($d, true), gettype($d)), __LINE__);
        }
        $this->d = $d;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\TipaltiResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get s value
     * @return string|null
     */
    public function getS()
    {
        return $this->s;
    }
    /**
     * Set s value
     * @param string $s
     * @return \StructType\TipaltiResponse
     */
    public function setS($s = null)
    {
        // validation for constraint: string
        if (!is_null($s) && !is_string($s)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s, true), gettype($s)), __LINE__);
        }
        $this->s = $s;
        return $this;
    }
}
